#include <AztecMainPCH.h>

#include <MFloatKey.h>

#include <funcs/KeyFuncGraphEdit.h>

#include "MdlMsgs.h"

#include <main/MdlGlobs.h>
#include <main/DlgGlobs.h>

#include <views/GraphViewWnd.h>

#include <tools/MGraphSelectTool.h>
#include <tools/MGraphMoveTool.h>
#include <tools/MGraphInsertKeyTool.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int graphSelectTool() {
  g_ToolMan.setTool(new MGraphSelectTool(), "graphView");
  return 1;
}

int graphMoveTool() {
  g_ToolMan.setTool(new MGraphMoveTool(), "graphView");
  return 1;
}

int graphInsertTool() {
  g_ToolMan.setTool(new MGraphInsertKeyTool(), "graphView");
  return 1;
}

int graphMergeSelectedKeys() {
  CGraphViewWnd *graphView = AZTEC_CAST(CGraphViewWnd, g_CurView);

  if (graphView == NULL) {
    g_SysMan->logOutput("Cannot merge selected keys when the current view is not a Graph View");
    return 0;
  }

  CGraphComponent *graph = graphView->getGraphComponent();
  std::vector<GraphPair> graphValues;

  graph->getGraphValues(graphValues);

  // iterate over the graph values, and try and merge selected keys
  for (int index = 0; index < graphValues.size(); ++index) {
    MFloatValuePtr value = graphValues[index].value;
    MFloatKeyList *keyList = AZTEC_CAST(MFloatKeyList, value);

    // if we have a valid key list, work with that.
    if (keyList != NULL) {
      // loop over the selected keys, and merge the two together
      std::vector<int> keyTimes;

      keyList->getSelectedKeyTimes(keyTimes);

      // if we have no selected keys, or just one, then we just continue 
      // on to the next keylist.
      if (keyTimes.size() <= 1) {
        continue;
      }

      long avgTime = 0;
      float avgValue = 0.0;

      // now we calculate the average time for the selected keys.
      for (int keyIndex = 0; keyIndex < keyTimes.size(); ++keyIndex) {
        avgTime += keyTimes[keyIndex];
        avgValue += keyList->getValueAtTime(keyTimes[keyIndex]);
      }
      avgTime /= keyTimes.size();
      avgValue /= keyTimes.size();

      // now round the time off to the granularity
      avgTime = ((int)(0.5 + (float)avgTime / keyList->getGranularity()))*keyList->getGranularity();

      // now remove all the keys except for the first one.
      for (int keyIndex = keyTimes.size() - 1; keyIndex > 0; --keyIndex) {
        keyList->deleteKey(keyTimes[keyIndex]);
      }

      MFloatKeyPtr key = AZTEC_CAST(MFloatKey, keyList->getKeyAtTime(keyTimes[0]));

      key->setKeyTime(avgTime);
      key->setValue(avgValue);
    }

  }

	g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
	g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);

  return 1;
}

void InitGraphActionList(MActionListType *AL) {
  g_SysMan->logOutput("Initialising Graph Edit Action List");
  
  // Viewport functions
  AL->Add("GraphSelectTool", "Graph Select Tool", "Graph Edit", graphSelectTool);
  AL->Add("GraphMoveTool", "Graph Move Tool", "Graph Edit", graphMoveTool);
  AL->Add("GraphInsertKeyTool", "Graph Insert Tool", "Graph Edit", graphInsertTool);
  AL->Add("GraphMergeSelectedKeys", "Merge Selected Keys", "Graph Edit", graphMergeSelectedKeys);
}

