// TimeScroller.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "timescroller.h"

#include <MKey.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



//----------------------------------------------------------------------------------------
//  CTimerScroller
//----------------------------------------------------------------------------------------

CTimeScroller::CTimeScroller() {
  m_Tracking = false;
  m_StartEdit = NULL;
  m_EndEdit = NULL;
}

CTimeScroller::~CTimeScroller() {
}


BEGIN_MESSAGE_MAP(CTimeScroller, CWnd)
//{{AFX_MSG_MAP(CTimeScroller)
ON_WM_PAINT()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CTimeScroller::SetScrollRange(int Min, int Max) {
  m_ScrollMin = Min;
  m_ScrollMax = Max;
  
  if (m_ScrollPos < Min) {
    m_ScrollPos = Min;
  }
  
  if (m_ScrollPos > Max) {
    m_ScrollPos = Max;
  }

  return TRUE;
}

BOOL CTimeScroller::SetScrollPos(int Pos) {
  m_ScrollPos = Pos;
  
  if (m_ScrollPos < m_ScrollMin)
    m_ScrollPos = m_ScrollMin;
  
  if (m_ScrollPos > m_ScrollMax)
    m_ScrollPos = m_ScrollMax;

  return TRUE;
}

int CTimeScroller::GetScrollPos() {
  return m_ScrollPos;
}


int CTimeScroller::calcMajorTickSize(int width, int fromNum, int toNum, HDC dc) {
  // start off with a tick size of 5.
  int result = 1;
  int lastEndPos;

  int numTicks;
  float tickStep;

  // Go through the ticks, and set an acceptable tick major value
tryagain:
  {
    lastEndPos = 0;
    
    numTicks = toNum - fromNum + 1;
    tickStep = (float)width / numTicks;
    
    for (int n = 0; n < numTicks; n++)
    {
      int   xPos;
      char  NumStr[16];
      
      xPos = (int)(tickStep*n);
      
      if (n % result == 0)
      {
        // Draw the label text
        sprintf(NumStr, "%i", n);
        
        // Make sure that the new text position is in front
        // of the end of the last bit of text. If it does't over
        // lap, keep going, if it does, then increase our major tick size.
        if (xPos + 2 > lastEndPos) {
          SIZE  size;
          
          ::GetTextExtentPoint32(dc, NumStr, strlen(NumStr), &size);            
          
          lastEndPos += size.cx + 8;
        } else {
          result += 5;
          result -= result % 5; 
          goto tryagain;
        }
        
      }
      
    }
    
  }
  

  return result;
}


void CTimeScroller::OnPaint() {
  updateEditBoxes();

  CPaintDC    Paintdc(this); // device context for painting
  
  HDC         dc;
  HBITMAP     bitmap, oldBitmap;

  RECT        ClientRect, Rect;
  HBRUSH      hBrush;
  HFONT       hOldFont;
  float       TickStep;
  int         n, NumTicks, LastTextEndPos, TickStart;
  int         TickMajor = 5;
  
  GetClientRect(&ClientRect);
  
  dc = ::CreateCompatibleDC(Paintdc.m_hDC);
  bitmap = ::CreateCompatibleBitmap(Paintdc.m_hDC, ClientRect.right, ClientRect.bottom);
  oldBitmap = (HBITMAP)::SelectObject(dc, bitmap);
  
  hOldFont = (HFONT)::SelectObject(dc, GetStockObject(DEFAULT_GUI_FONT));
  
  
  {
    HPEN        hPen, hOldPen;
    
    hPen = CreatePen(PS_SOLID, 1, 0x000000);
    hOldPen = (HPEN)::SelectObject(dc, hPen);
    ::Rectangle(dc, 0,0,ClientRect.right, ClientRect.bottom);
    ::SelectObject(dc, hOldPen);
    DeleteObject(hPen);
    
    ClientRect.left += 1;
    ClientRect.top += 1;
    ClientRect.right  -= 1;
    ClientRect.bottom -= 1;
  }
  
  hBrush = ::CreateSolidBrush( GetSysColor(COLOR_SCROLLBAR) );
  ::FillRect(dc, &ClientRect, hBrush);
  ::DeleteObject(hBrush);
  
  LastTextEndPos = 0;
  
  // Draw the Ticks
  ::SetBkMode(dc, TRANSPARENT);
  
  TickMajor = calcMajorTickSize(ClientRect.right - ClientRect.left, m_ScrollMin, m_ScrollMax, dc);
  NumTicks = m_ScrollMax - m_ScrollMin + 1;
  TickStart = ClientRect.left;
  TickStep = (float)(ClientRect.right-TickStart) / NumTicks;

  // Draw the tick marks.
  for (n = 0; n < NumTicks; n += TickMajor) {
    Rect.left = (int)(TickStep*n) + ClientRect.left;
    Rect.right = Rect.left + 2;
    Rect.top = ClientRect.top;
    Rect.bottom = ClientRect.bottom;

   ::FillRect(dc, &Rect, (HBRUSH)GetStockObject(BLACK_BRUSH));
  }

  // Draw the current cursor
  {
    hBrush = ::CreateSolidBrush(0xFFAA00);
    
    Rect.left = (int)(TickStep*(m_ScrollPos-m_ScrollMin)) + TickStart;
    Rect.right = (int)(TickStep*((m_ScrollPos-m_ScrollMin+1))) + TickStart;
    if (Rect.left == Rect.right) {
      Rect.right++;
    }
    
    Rect.top = ClientRect.top;
    Rect.bottom = ClientRect.bottom;
    
    ::FillRect(dc, &Rect, hBrush);
    
    ::DeleteObject(hBrush);
  }

  // Draw the Frame Numbers
  for (n = 0; n < NumTicks; n += TickMajor) {
    int xPos = (int)(TickStep*n) + ClientRect.left + 2;
    char  NumStr[16];
    sprintf(NumStr, "%i", n + m_ScrollMin);
      
    ::TextOut(dc, xPos, 1, NumStr, strlen(NumStr));

  }

  // Draw any of the keys in red marks
  MBaseObjectPtr Obj;
  MKeyableValuePtr keyableValue;
  
  KeyValueSet::iterator it;


  hBrush = ::CreateSolidBrush(0x0000FF);
      
  for (it = m_KeyingList.begin(); it != m_KeyingList.end(); ++it) {
    keyableValue = *it;
    
    std::vector<int> keyTimes;

    (*it)->getKeyTimes(keyTimes);
    for (int n = 0; n < keyTimes.size(); ++n) {
      MKeyPtr Key;
      int         Time;
      float       Pos;
      
      Time = keyTimes[n];
      
      Pos = (float)Time / 120;
      
      Rect.left = (int)(TickStep*Pos) + TickStart;
      
      Rect.right = (int)(TickStep*(Pos+1)) + TickStart;
      if (Rect.left == Rect.right)
        Rect.right ++;
      
      Rect.right = Rect.left+2;
      
      Rect.top = ClientRect.top;
      Rect.bottom = ClientRect.bottom;
      
      ::FillRect(dc, &Rect, hBrush);
    }
  }
  
  ::DeleteObject(hBrush);
  ::SelectObject(dc, hOldFont);
  
  GetClientRect(&ClientRect);

  ::BitBlt(Paintdc.m_hDC, 0,0,ClientRect.right, ClientRect.bottom, dc, 0,0,SRCCOPY);

  ::SelectObject(dc, oldBitmap);
  ::DeleteObject(bitmap);
  ::DeleteDC(dc);
}

LRESULT CTimeScroller::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
  if (message == WM_LBUTTONDOWN) {
    int      NumTicks, xPos, yPos, NewPos;
    float    TickStep;
    RECT     ClientRect;
    
    // Notify the parent window that the time scroll is about to change
    ::PostMessage(::GetParent(m_hWnd), TS_TIMESCROLL_BEFORECHANGE, 0,m_ScrollPos);
    
    ::GetClientRect(m_hWnd, &ClientRect);
    
    NumTicks = m_ScrollMax - m_ScrollMin;
    TickStep = (float)ClientRect.right / NumTicks;
    
    xPos = (short)LOWORD(lParam);  // horizontal position of cursor 
    yPos = HIWORD(lParam);  // vertical position of cursor
    
    NewPos = (int)((float)xPos / TickStep+0.5) + m_ScrollMin;
    
    if (NewPos != m_ScrollPos) {
      SetScrollPos(NewPos);
      
      // Notify the parent window that scroll position has changed
      ::PostMessage(::GetParent(m_hWnd), WM_HSCROLL, SB_THUMBTRACK + (m_ScrollPos << 8), (long)m_hWnd);
      ::InvalidateRect(m_hWnd, &ClientRect, FALSE);
    }
    m_Tracking = true;
    ::SetCapture(m_hWnd);
    
    return 1;
  }
  if (message == WM_LBUTTONUP) {
    if (m_Tracking) {
      m_Tracking = false;
      ::ReleaseCapture();
      
      // Notify the parent window that the time scroll has changed
      ::PostMessage(::GetParent(m_hWnd), TS_TIMESCROLL_AFTERCHANGE, 0,m_ScrollPos);
    }
  } 

  if (message == WM_MOUSEMOVE) {
    if (m_Tracking) {
      int      NumTicks, xPos, yPos, NewPos;
      float    TickStep;
      RECT     ClientRect;
      
      ::GetClientRect(m_hWnd, &ClientRect);
      
      NumTicks = m_ScrollMax - m_ScrollMin;
      TickStep = (float)ClientRect.right / NumTicks;
      
      xPos = (short)LOWORD(lParam);  // horizontal position of cursor 
      yPos = HIWORD(lParam);  // vertical position of cursor
      
      NewPos = (int)((float)(xPos / TickStep)+0.5) + m_ScrollMin;
      
      if (NewPos != m_ScrollPos) {
        SetScrollPos(NewPos);
        
        // Notify the parent window that scroll position has changed
        ::PostMessage(::GetParent(m_hWnd), WM_HSCROLL, SB_THUMBTRACK + (m_ScrollPos << 8), (long)m_hWnd);
        ::InvalidateRect(m_hWnd, &ClientRect, FALSE);
        ::SendMessage(m_hWnd, WM_PAINT, 0,0);
      }
      return 1;
    }
  }
  if (message == WM_ERASEBKGND) {
    return 1;
  }
  
  return CWnd::WindowProc(message, wParam, lParam);
}

void CTimeScroller::ClearAllKeyLists() {
   m_KeyingList.clear();
}

void CTimeScroller::addKeyableValue(MKeyableValuePtr value) {
  if (value != NULL) {
    m_KeyingList.insert(value);
  }
}

void CTimeScroller::setEditBoxes(CEdit *startEdit, CEdit *endEdit) {
  m_StartEdit = startEdit;
  m_EndEdit = endEdit;
}

void CTimeScroller::updateEditBoxes() {
  updateEditBox(m_StartEdit, m_ScrollMin);
  updateEditBox(m_EndEdit, m_ScrollMax);
}

void CTimeScroller::updateEditBox(CEdit *editBox, int value) {
  if (editBox != NULL && ::IsWindow(editBox->m_hWnd)) {
    CString curVal, newVal;

    editBox->GetWindowText(curVal);
    newVal.Format("%i", value);

    if (curVal != newVal) {
      editBox->SetWindowText((LPCTSTR)newVal);
    }
  }
}



