#ifndef GraphViewWnd_Header
#define GraphViewWnd_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <params/MKeyParameter.h>
#include <params/MVector3KeyParameter.h>

#include "BaseViewWnd.h"
#include "BaseOpenGLWnd.h"
#include <controls/ShelfDlg.h>
#include <controls/GraphComponent.h>
#include <views/MZoomableWindow.h>

#include <map>

class CGraphViewWnd : public MBaseViewWnd, public MZoomableWindow
{
// Construction
public:
  CGraphViewWnd();
  
  // Class related
  virtual MStr getClassName() {return MStr("CGraphViewWnd");};
  virtual MStr getParentClassName() {return MStr("MBaseViewWnd");};
  virtual MBaseObjectPtr createNew();
  
  virtual void ViewCreate();
  virtual void DrawView();
  
  virtual DWORD ViewPopupMenu(int x, int y);
  virtual int HandlePopupCommand(DWORD Cmd);

  CGraphComponent* getGraphComponent();

  void doZoomToFit(bool doSelection);

  void deleteSelectedKeys();

  // MBaseViewWnd methods
  void onMouseDown(int x, int y, MShiftState Shift);
  void onMouseUp(int x, int y, MShiftState Shift);
  void onMouseMove(int x, int y, MShiftState Shift);

  // MZoomableWindow methods
  void zoomIn();
  void zoomOut();
  void zoomToFitAll();
  void zoomToFitSelected();

private:
  CShelfDlg *topShelf;

  HDC paintDC;
  int shiftingSplitPos;
  int m_SplitPos;
  int splitBarWidth;
  bool splitDragging;
  int lastXPos;
  
  MRefCountedPtr<CGraphComponent> m_Graph;
  CTreeCtrl *paramListTree;

  // TODO: place this in MKeyParameter.h
  typedef MRefCountedPtr<MKeyParameter> MKeyParameterPtr;

  std::map<MSceneObjectPtr, HTREEITEM> selectedObjects;
  std::map<HTREEITEM, MKeyableValuePtr> itemParamMap;
  std::map<MKeyableValuePtr, HTREEITEM> paramItemMap;

  typedef std::set<MKeyableValuePtr> KeyParamSet;
  KeyParamSet selectedParams;

  void updateTreeFromScene();
  void addParameters(HTREEITEM parentItem, const MParameterObjectListPtr &paramList);
  void addParameters(HTREEITEM parentItem, const MVector3KeyParameterPtr &vectorParam);

  void addParameter(HTREEITEM item, const MKeyableValuePtr &param);
  MKeyableValuePtr getParameterFromTree(HTREEITEM item);
  HTREEITEM getTreeItem(const MKeyableValuePtr &param);

public:
  // Overrides
  // ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGraphViewWnd)
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CGraphViewWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CGraphViewWnd)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnClose();
	afx_msg void OnPaint();
  afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKVIEWWND_H__49925471_455F_11D3_9A66_0040332C7B2F__INCLUDED_)
