#ifndef MToolManager_Header
#define MToolManager_Header

#include "MToolType.h"

#include <list>
#include <map>

//----------------
//  MToolManager
//----------------
#define TOOLMAN_MAXNODES      10

class MToolChangeListener;
typedef MRefCountedPtr<MToolChangeListener> MToolChangeListenerPtr;


class MToolChangeListener : public MRefCountedObject {
public:
  typedef MToolChangeListenerPtr Ptr;

  virtual void onToolChange(const std::string &group, MToolTypePtr oldTool) = 0;
};

class MToolManager {
protected:
  typedef std::list<MToolTypePtr> ToolList;
  typedef std::map<std::string, ToolList> ToolListMap;
  typedef std::map<std::string, MToolTypePtr> defaultTools;

  bool m_TempTool;    // True if topmost tool is temporary

  ToolListMap toolMap;
  std::set<MToolChangeListenerPtr> m_Listeners;

  void notifyListeners(MToolTypePtr oldTool, const std::string &group = "");

  ToolList& getToolList(const std::string &group);
public:
  MToolManager();
  virtual ~MToolManager();
  
  void setTool(const MToolTypePtr &newTool, const std::string &group = "");
  void PushTool(const MToolTypePtr &newTool, const std::string &group = "");
  MToolTypePtr PopTool(const std::string &group = "");
  
  MToolTypePtr GetTool(const std::string &group = "");
  MToolTypePtr GetTool(int index, const std::string &group = "");       // Get the nth Tool
  
  void DeleteList();
  
  void setTemporary(const MToolTypePtr &Tool, const std::string &group = "");
  void UnsetTemporary(const std::string &group = "");
  bool IsTemporary(const std::string &group = "");

  /**
   * This sets up the default tool to use for a category when no other tool
   * is selected.
   */
  void setDefaultTool(const std::string &group, const MToolTypePtr &defaultTool);
  
  void addListener(MToolChangeListenerPtr listener, const std::string &group = "");
  void removeListener(MToolChangeListenerPtr listener, const std::string &group = "");
  void removeAllListeners(const std::string &group = "");
};

#endif