#ifndef CameraTools_Header
#define CameraTools_Header

#include <MToolType.h>

//----------------------------------------------------------------------------------------
//  MPanOrbitToolType
//----------------------------------------------------------------------------------------
class MPanOrbitToolType : public MToolType
{
protected:
   int      m_OldX, m_OldY;
public:
   MPanOrbitToolType(int OX, int OY) {setName("KToolPanOrbit"); m_OldX = OX; m_OldY = OY;};
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int WrapMouse() {return 1;};
};

//----------------------------------------------------------------------------------------
//  MPanTrackToolType
//----------------------------------------------------------------------------------------
class MPanTrackToolType : public MToolType
{
protected:
   int      m_OldX, m_OldY;
public:
   MPanTrackToolType(int OX, int OY) {setName("KToolPanTrack"); m_OldX = OX; m_OldY = OY;};
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int WrapMouse() {return 1;};
};

//----------------------------------------------------------------------------------------
//  MPanZoomToolType
//----------------------------------------------------------------------------------------
class MPanZoomToolType : public MToolType
{
protected:
   int      m_OldX, m_OldY;
public:
   MPanZoomToolType(int OX, int OY) {setName("KToolPanZoom"); m_OldX = OX; m_OldY = OY;};
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int WrapMouse() {return 1;};
};

#endif