//---------------------------------------------------------------------------
#ifndef MdlConstH
#define MdlConstH
//---------------------------------------------------------------------------

#include "MStr.h"
#include "MMath.h"
#include "MStreams.h"

enum MActionType {atNone, atSelect, atSelectBox, atDeselectBox,	atDeselect,
               atPanTrack, atPanOrbit, atPanZoom, atPanPersp, 
               atRotate, atMove, atScale,
               atCreateVertex, atCreatingVertex,
               atBuildFace, atBuildingFace1, atBuildingFace2, atBuildingFaceDone,
               atCreateBone, atAssignParent, atAssignVertToBone,
               atDraw,atMidPointMove,atEyeDropper, atTurnEdge};
enum MSelectType {stVertex,stTriangle,stBone};


//----------------------------------------------------------------------------------------
//  MShiftState
//----------------------------------------------------------------------------------------
class MShiftState {
public:
   bool  m_Shift, m_Ctrl, m_Alt, m_Left, m_Right, m_Mid;

   MShiftState();
   void SetFromFlags(UINT nFlags);
   UINT SetIntoFlags();
   void SetFromKeyState();

   bool operator==(const MShiftState &RHS);
   void ProcessMessage(UINT message, WPARAM wParam, LPARAM lParam);

   void ReadFromStream(MInputStream &stream);
   void WriteToStream(MOutputStream &stream);
};


#endif

