#ifndef SegmentEditor_Header
#define SegmentEditor_Header


#define SE_SEGMENTEDITOR_BEFORECHANGE     WM_USER+7001
#define SE_SEGMENTEDITOR_AFTERCHANGE      WM_USER+7002


#include "MTimeSegment.h"
#include "MListsTrees.h"

#include <vector>
#include <utility>

// this is a little helper class to help with the 
// drawing and keeping track of time segments in the gui
class CSegmentGUI {
public:
  MTimeSegment::Ptr timeSegment;
  RECT drawRect;
  RECT boundingBox;
  MVector3 colourVec;
  DWORD colour;
  DWORD hilightCol, shadowCol;
  DWORD textColour;
  DWORD selectedCol;

  static DWORD vectorToColour(const MVector3 &vec) {
    DWORD col;
    BYTE r,g,b;
    MVector3 temp = vec;
    if (temp.x < 0.0) temp.x = 0.0;
    if (temp.x > 1.0) temp.x = 1.0;
    if (temp.y < 0.0) temp.y = 0.0;
    if (temp.y > 1.0) temp.y = 1.0;
    if (temp.z < 0.0) temp.z = 0.0;
    if (temp.z > 1.0) temp.z = 1.0;

    b = (BYTE)(temp.x * 255);
    g = (BYTE)(temp.y * 255);
    r = (BYTE)(temp.z * 255);

    col = (r << 16) + (g << 8) + b;

    return col;
  }

  static bool RECTsIntersect(const RECT &r1, const RECT &r2) {
    return !((r2.right <= r1.left) ||
      (r2.bottom <= r1.top) ||
      (r2.left >= r1.right) ||
      (r2.top >= r1.bottom));  
  }
};

//----------------------------------------------------------------------------------------
//  CSegmentEditor
//----------------------------------------------------------------------------------------
class CSegmentEditor : public CWnd
{
public:
	CSegmentEditor();

  BOOL SetScrollRange(int Min, int Max);
  BOOL SetScrollPos(int Pos);
  int GetScrollPos();
  int GetScrollMin() { return m_ScrollMin; }
  int GetScrollMax() { return m_ScrollMax; }
  
  void setAutoOrganise(bool organise);
  void setDrawTimeline(bool drawTimeline);
  void setHeadings(bool headingsOn);

  int GetHeight();
  int getPreferredHeight();
  void setPreferredHeight(int height);

  void scroll(int xAmount, int yAmount);
  int getNumberOfVisibleSegments() { return m_LastSegmentCount; }
  CSegmentGUI* getSegmentAt(int x, int y);

protected:
  int m_ScrollMin, m_ScrollMax;
  bool m_Tracking;

  /**
   * This is the x coordinate of the mouse 
   * when a mouse button had been presed.
   */
  int m_DownX;

  /**
   * This is the initial value of whatever thing we are changing.
   */
  std::vector< std::pair<int, int> > m_InitialValues;

  /**
   * indicated if we are currently resizing a segment
   */
  bool m_Resizing;

  /**
   * indicates which, if any, sgment we are in the process
   * of resizing.
   */
  CSegmentGUI *m_AdjustingSeg;

  /**
   * Indicates which side we are resizing, left, middle,
   * or the right hand side. -1 for left
   */
  int m_Side;

  /**
   * Should we draw a Time line above everything?
   */
  bool m_DrawTimeline;

  /**
   * This says if it should draw the names of segments
   * on the left or not.
   */
  bool m_DrawHeadings;

  /**
   * This is the width of the column displaying all the segment
   * names, if the control is indeed drawing the headings.
   * This defaults to 110.
   */
  int m_HeadingWidth;

  /**
   * This is the amount that we have scrolled vertically.
   */
  int m_YScroll;

  /**
   * This is the last number of segments that were visible vertically.
   */
  int m_LastSegmentCount;

  static const int NONE;
  static const int LEFT;
  static const int RIGHT;
  static const int MIDDLE;

  CSegmentGUI *m_Segments;
  int m_SegmentCount;
  int m_PrefHeight;
  bool m_AutoOrganise;
  
  void setSegmentCount(int count);  
  void retrieveTimeSegments();

  void doLeftMouseDown(int xPos, int yPos, DWORD flags);
  void doRightMouseDown(int xPos, int yPos, DWORD flags);
  void doMouseMove(int xPos, int yPos, DWORD flags);
  DWORD ViewPopupMenu(int x, int y);
  int HandlePopupCommand(DWORD Cmd);

  /**
   * If this control is inside a view object,
   * set that view to be the current view.
   */
  void setViewAsCurrent();

  /**
   * This takes a snapshot of all the segments start and end
   * values and puts them in the m_InitialValues member.
   */
  void takeSegmentSnapshot();

public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSegmentEditor)
	protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSegmentEditor();

	// Generated message map functions
protected:
	//{{AFX_MSG(CSegmentEditor)
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TIMESCROLLER_H__2C259AD6_11AE_11D3_8452_0040332C7B2F__INCLUDED_)
