#ifndef GraphComponent_Header
#define GraphComponent_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <MFloatValue.h>
#include <MFloatKeyList.h>

#include <controls/GLCanvas.h>
#include <tools/MToolType.h>

class GraphPair {
public:
  GraphPair(MFloatValuePtr v, MVector3 c) 
    : value(v), colour(c) { }

  GraphPair(const GraphPair& src) 
    : value(src.value), colour(src.colour) { }

  MFloatValuePtr value;
  MVector3 colour;
};

class CGraphComponent : public GLCanvas, public virtual MRefCountedObject {

public:
  CGraphComponent(MBaseViewWnd *parentView);
  ~CGraphComponent();

  void DrawView();

  // MBaseViewWnd methods
  bool isCurrentView();
  void setAsCurrentView();
  DWORD ViewPopupMenu(int x, int y);
  int HandlePopupCommand(DWORD Cmd);
  void onMouseUp(int X, int Y, MShiftState Shift);
  void onMouseDown(int X, int Y, MShiftState Shift);
  void onMouseMove(int x, int y, MShiftState Shift);
  MToolTypePtr getSelectTool();
  bool isAnythingSelected();

  void setGraphValues(const std::vector<GraphPair> &values);
  void getGraphValues(std::vector<GraphPair> &values);
  
  typedef std::pair<MFloatKeyListPtr, int> ListKey;

  void clientToGraph(int x, int y, float &nx, float &ny) const;
  void graphToClient(float x, float y, int &nx, int &ny) const;
  void graphToClient(float x, float y, long &nx, long &ny) const;
  void getKeysInRect(const RECT &rect, std::vector<ListKey> &keys);
  void getKeysAtPoint(int x, int y, std::vector<ListKey> &keys, int radius = 3);
  MFloatKeyListPtr getKeyListAtMouse(int mouseX, int mouseY);

  void getGraphRange(float &min, float &max);
  void setGraphRange(float min, float max);

  void getValueRange(float &min, float &max);
  void setValueRange(float min, float max);

private:
  MBaseViewWnd *parentView;
  bool m_Dragging;
  float minTick;
  float maxTick;
  float minValue;
  float maxValue;
  int m_CurX, m_CurY;
  int m_DownX, m_DownY;
  int m_UpX, m_UpY;
  MShiftState shiftState;

  std::vector<GraphPair> graphValues;

  void initialiseRendering();
  void renderXAxis() const;
  void renderYAxis() const;

	// Generated message map functions
protected:
	//{{AFX_MSG(COpenGLWnd)
	afx_msg void OnPaint();
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnDestroy();
  afx_msg void OnHScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar );
  afx_msg void OnVScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar );
  afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif 
