#include "StdAfx.h"

#include <params/MVector3KeyParameter.h>

#include "MSystemManager.h"
#include "MDAGraph.h"

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------
  //  MVector3KeyParameterImpl
  //---------------------
  MVector3KeyParameterImpl::MVector3KeyParameterImpl(const MStr &shortName, const MStr &longName, const MStr &friendlyName, int meaning) 
    : MVector3ParameterImpl(shortName, longName, friendlyName, meaning)
  {
    m_Vector3KeyList = new MVector3KeyList;
    addInput(&*m_Vector3KeyList);
  }
  
  MVector3KeyParameterImpl::~MVector3KeyParameterImpl() {
  }

  MVector3ValuePtr MVector3KeyParameterImpl::getVector3Value() {
    return m_Vector3KeyList;
  }

  void MVector3KeyParameterImpl::createXKeyAt(long time) {
    m_Vector3KeyList->setXKey(m_Value.x, time);
  }

  void MVector3KeyParameterImpl::createYKeyAt(long time) {
    m_Vector3KeyList->setYKey(m_Value.y, time);
  }

  void MVector3KeyParameterImpl::createZKeyAt(long time) {
    m_Vector3KeyList->setZKey(m_Value.z, time);
  }

  MFloatKeyParameterPtr MVector3KeyParameterImpl::getXParameter() {
    return new MFloatKeyParameterImpl(getShortName() + "x", 
                                      getLongName() + "x",
                                      getFriendlyName() + " X",
                                      m_Vector3KeyList->getXValue());
  }

  MFloatKeyParameterPtr MVector3KeyParameterImpl::getYParameter() {
    return new MFloatKeyParameterImpl(getShortName() + "y", 
                                      getLongName() + "y",
                                      getFriendlyName() + " Y",
                                      m_Vector3KeyList->getYValue());
  }

  MFloatKeyParameterPtr MVector3KeyParameterImpl::getZParameter() {
    return new MFloatKeyParameterImpl(getShortName() + "z", 
                                      getLongName() + "z",
                                      getFriendlyName() + " Z",
                                      m_Vector3KeyList->getZValue());
  }


  MVector3 MVector3KeyParameterImpl::getValue() {
    updateObject();
    return m_Value;
  }

  MVector3 MVector3KeyParameterImpl::getValue(long time) {
    if (getInputParameter() != NULL) {
      bool result = getInputParameter()->getValueVector(m_TempVal);
      unsetFlag(OBJECTFLAG_NEEDS_UPDATE);
      return m_TempVal;
    }

    m_TempVal = m_Vector3KeyList->getValueAtTime(time);

    return m_TempVal;
  }

  bool MVector3KeyParameterImpl::createKeyAt(long time) {
    m_Vector3KeyList->setKey(m_Value, time);
    return true;
  }

  bool MVector3KeyParameterImpl::setValueVector(const MVector3 &value) {
    MVector3ParameterImpl::setValueVector(value);

    m_Vector3KeyList->setInitialValue(m_Value);

    return true;
  }

  MKeyableValuePtr MVector3KeyParameterImpl::getKeyableValue() {
    return m_Vector3KeyList;
  }

  bool MVector3KeyParameterImpl::doUpdateObject() {
    MVector3ParameterImpl::doUpdateObject();

    // if we have do not have a parameter as our input, then we update the value as we should
    if (getInputParameter() == NULL) {
      m_Value = m_Vector3KeyList->getValueAtTime(getTime());
    }

    return true;
  }

  bool MVector3KeyParameterImpl::setFromParameter(MParameterObjectPtr src) {
    MVector3ParameterImpl::setFromParameter(src);

    MKeyParameterPtr param = AZTEC_CAST(MKeyParameter, src);

    if (param != NULL) {
      getKeyableValue()->copyFromValue(param->getKeyableValue());
    }

    return true;
  }

  MParameterObjectPtr MVector3KeyParameterImpl::createCopy() {
    return createParameterCopy(this);
  }
}
