#include "StdAfx.h"

//#include "MSystemManager.h"
#include "params/MTransformMatrixParameter.h"

//#include "MDAGraph.h"

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------
  //  MMatrix4Parameter
  //---------------------
  MTransformMatrixParameter::MTransformMatrixParameter( 
                                  const MStr &shortName, 
                                  const MStr &longName, 
                                  const MStr &friendlyName,
                                  MVector3ParameterPtr transParam, 
                                  MVector3ParameterPtr rotParam,
                                  MVector3ParameterPtr scaleParam, 
                                  MVector3ParameterPtr pivotParam, 
                                  MMatrix4ParameterPtr parentXFormParam)
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL) 
  {
    setInputs(transParam, rotParam, scaleParam, pivotParam, parentXFormParam);
  }
  
  MTransformMatrixParameter::~MTransformMatrixParameter() {
  }

  void MTransformMatrixParameter::setInputs( MVector3ParameterPtr transParam, 
                                    MVector3ParameterPtr rotParam, 
                                    MVector3ParameterPtr scaleParam, 
                                    MVector3ParameterPtr pivotParam, 
                                    MMatrix4ParameterPtr parentXFormParam)
  {
    if (m_ParentXForm != NULL) removeInput(&*m_ParentXForm);
    if (m_Translate != NULL) removeInput(&*m_Translate);
    if (m_Rotate != NULL) removeInput(&*m_Rotate);
    if (m_Scale != NULL) removeInput(&*m_Scale);
    if (m_Pivot != NULL) removeInput(&*m_Pivot);

    m_ParentXForm = parentXFormParam;
    m_Translate = transParam;
    m_Rotate = rotParam;
    m_Scale = scaleParam;

    if (m_ParentXForm != NULL) addInput(&*m_ParentXForm);
    if (m_Translate != NULL) addInput(&*m_Translate);
    if (m_Rotate != NULL) addInput(&*m_Rotate);
    if (m_Scale != NULL) addInput(&*m_Scale);
    if (m_Pivot != NULL) addInput(&*m_Pivot);
  }

  const MMatrix4& MTransformMatrixParameter::getValue() {
    updateObject();
    return m_Value;
  }

  bool MTransformMatrixParameter::getValueMatrix(MMatrix4 &value) {
    updateObject();
    value = m_Value;
    return true;
  }

  bool MTransformMatrixParameter::setValueMatrix(const MMatrix4 &value) {
    return false;
  }

  bool MTransformMatrixParameter::getValueString(MStr &value) {
    return false;
  }

  bool MTransformMatrixParameter::getValueInteger(int &value) {
    return false;
  }

  bool MTransformMatrixParameter::getValueFloat(float &value) {
    return false;
  }

  bool MTransformMatrixParameter::getValueBoolean(bool &value) {
    return false;
  }

  bool MTransformMatrixParameter::getValueVector(MVector3 &value) {
    return false;
  }


  bool MTransformMatrixParameter::setValueString(const MStr &value) {
    return false;
  }

  bool MTransformMatrixParameter::setValueInteger(int value) {
    return false;
  }

  bool MTransformMatrixParameter::setValueFloat(float value) {
    return false;
  }

  bool MTransformMatrixParameter::setValueBoolean(bool value) {
    return false;
  }

  bool MTransformMatrixParameter::setValueVector(const MVector3 &value) {
    return false;
  }

  bool MTransformMatrixParameter::setValueParameter(const MParameterObjectPtr &src) {
    // we don't actually do anything here, because our values are always
    // derived.
    return false;
  }

  bool MTransformMatrixParameter::createKeyAt(long time) {
    // we can't set a key for this parameter, as it is always calculated.
    return false;
  }

  MParameterObjectPtr MTransformMatrixParameter::createCopy() {
    // now we only create a MMatrix4ParameterImpl here because we want
    // to store an in memory copy, not an actual MTransformMatrixParameter.
    // If we did use a MTransformMatrixParameter, it would attempt to calculate
    // the transform information each time, which is not something we want.
    return new MMatrix4ParameterImpl(getShortName(), getLongName(), getFriendlyName());
  }

  bool MTransformMatrixParameter::doUpdateObject() {
    MParameterObject::doUpdateObject();

    // We calculate the value of this parameter based on our inputs

    MMatrix4 TransMat, RotMat, ScaleMat, PivotMat, PivotMatInv;
    MVector3 translate, rotate, scale(1,1,1), pivot;

    if (m_Translate != NULL) translate = m_Translate->getValue();
    if (m_Rotate != NULL) rotate = m_Rotate->getValue();
    if (m_Scale != NULL) scale = m_Scale->getValue();
    if (m_Pivot != NULL) pivot = m_Pivot->getValue();
    
    TransMat.identity();
    TransMat.m[3][0] = translate.x;
    TransMat.m[3][1] = translate.y;
    TransMat.m[3][2] = translate.z;
    
    PivotMat.identity();
    PivotMat.m[3][0] = pivot.x;
    PivotMat.m[3][1] = pivot.y;
    PivotMat.m[3][2] = pivot.z;
    
    PivotMatInv.identity();
    PivotMatInv.m[3][0] = -pivot.x;
    PivotMatInv.m[3][1] = -pivot.y;
    PivotMatInv.m[3][2] = -pivot.z;
    
    ScaleMat.identity();
    ScaleMat.m[0][0] = scale.x;
    ScaleMat.m[1][1] = scale.y;
    ScaleMat.m[2][2] = scale.z;

    RotMat.convertFromEuler(3.1415926535f/180.0f * rotate);
    
    if (m_ParentXForm != NULL) {
      m_Value = m_ParentXForm->getValue() * (ScaleMat * (PivotMatInv * (RotMat * (PivotMat * TransMat))));
    } else {
      m_Value = ScaleMat * (PivotMatInv * (RotMat * (PivotMat * TransMat)));
    }

    return true;
  }
  
}
