#include "StdAfx.h"

#include "MSystemManager.h"
#include <params/MFloatParameter.h>

#include "MDAGraph.h"

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------
  //  MFloatParameterImpl
  //---------------------
  MFloatParameterImpl::MFloatParameterImpl(const MStr &shortName, const MStr &longName, const MStr &friendlyName) 
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL)
  {
    m_Value = 0.0;
  }
  
  MFloatParameterImpl::~MFloatParameterImpl() {
  }

  float MFloatParameterImpl::getValue() {
    updateObject();
    return m_Value; 
  }

  float MFloatParameterImpl::getValue(long time) {
    updateObject();
    return m_Value; 
  }
  
  bool MFloatParameterImpl::getValueString(MStr &value) {
    value.Format("%.4f", getValue(getTime()));
    return true;
  }

  bool MFloatParameterImpl::getValueInteger(int &value) {
    value = (int)(getValue(getTime()) + 0.5);
    return true;
  }

  bool MFloatParameterImpl::getValueFloat(float &value) {
    value = getValue(getTime());
    return true;
  }

  bool MFloatParameterImpl::getValueBoolean(bool &value) {
    value = (getValue(getTime()) >= 0.5);
    return true;
  }

  bool MFloatParameterImpl::getValueVector(MVector3 &value) {
    return false;
  }

  bool MFloatParameterImpl::setValueString(const MStr &value) {
    return setValueFloat(value.ToFloat());
  }

  bool MFloatParameterImpl::setValueInteger(int value) {
    return setValueFloat((float)value);
  }

  bool MFloatParameterImpl::setValueFloat(float value) {
    m_Value = value;
    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }

  bool MFloatParameterImpl::setValueBoolean(bool value) {
    if (value) {
      return setValueFloat(1.0);
    } else {
      return setValueFloat(0.0);
    }
  }

  bool MFloatParameterImpl::setValueVector(const MVector3 &value) {
    return false;
  }

  bool MFloatParameterImpl::setValueParameter(const MParameterObjectPtr &value) {
    float val;

    if (value->getValueFloat(val)) {
      setValueFloat(val);
      return true;
    }
    return false;
  }

  MParameterObjectPtr MFloatParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

  
}
