#include "StdAfx.h"

#include <MSystemManager.h>
#include <params/MParameterFactory.h>
#include <MTimeSegment.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


namespace Aztec {

  MTimeSegment::MTimeSegment() {

    m_SegmentName = MParameterFactory::createString("cap", "Caption", "Caption");
    m_StartParam = MParameterFactory::createInteger("start", "Start", "Start Time");
    m_EndParam = MParameterFactory::createInteger("end", "End", "End Time");
    m_ObjectsParam = MParameterFactory::createObjectList("objs", "Objects", "Objects");

    addParameter(m_SegmentName);
    addParameter(m_StartParam);
    addParameter(m_EndParam);
    addParameter(m_ObjectsParam);

    addParameter(MParameterFactory::createColour("clr", "Colour", "Colour"));
    addParameter(MParameterFactory::createInteger("fps", "fps", "FPS"));
    
    setParamByName("start", "0");
    setParamByName("end", "1800");
    setParamByName("clr", "1.0 0 0");
    if (getSystemManager()->getScene() != NULL) {
      MStr fpsStr;
      fpsStr.Format("%i", getSystemManager()->getScene()->getFramesPerSecond());

      setParamByName("fps", fpsStr);
    } else {
      setParamByName("fps", "30");
    }

    setFlag(OBJECTFLAG_NOCOMPONENTS);
  }
  
  MTimeSegment::~MTimeSegment() {
  }

  void MTimeSegment::setRange(int tickStart, int tickEnd) {
    // if our range is backwards, just flip it around
    if (tickStart > tickEnd) {
      int temp = tickEnd;
      tickEnd = tickStart;
      tickStart = temp;
    }

    m_StartParam->setValueInteger(tickStart);
    m_EndParam->setValueInteger(tickEnd);
  }

  int MTimeSegment::getStart() {
    return m_StartParam->getValue();
  }

  int MTimeSegment::getEnd() {
    return m_EndParam->getValue();
  }

  int MTimeSegment::getObjectCount() {
    return m_ObjectsParam->getObjectCount();
  }

  MNamedObjectPtr MTimeSegment::getObject(int index) {
    return m_ObjectsParam->getObject(index);
  }

  void MTimeSegment::getObjects(std::vector<MNamedObjectPtr> &objects) {
    objects = m_ObjectsParam->getValue();
  }

  void MTimeSegment::addObject(MNamedObjectPtr object) {
    m_ObjectsParam->addObject(object);
  }

  void MTimeSegment::removeObject(MNamedObjectPtr object) {
    m_ObjectsParam->removeObject(object);
  }

  void MTimeSegment::removeObject(int index) {
    m_ObjectsParam->removeObject( m_ObjectsParam->getObject(index) );
  }

  bool MTimeSegment::isObjectInSegment(MNamedObjectPtr object) {
    return m_ObjectsParam->isObjectInList(object);
  }

  

  // Class related
  MBaseObjectPtr MTimeSegment::createNew() {
    MTimeSegmentPtr NewObj;
    
    NewObj = new MTimeSegment;
    
    NewObj->setFrom(this);
    
    return NewObj;
  }

  void MTimeSegment::setFrom(MBaseObjectPtr SrcObj) {
    MNamedObject::setFrom(SrcObj);

    MTimeSegment *timeSeg = AZTEC_CAST(MTimeSegment, SrcObj);

    if (timeSeg == NULL) {
      return;
    }

  }
  
}