#include "StdAfx.h"

#include <MNamedObject.h>
#include <MListsTrees.h>

#include <params/MObjectParameter.h>
#include <params/MUniqueNameParameter.h>

#include "scripting/ScriptSceneObject.h"

#include <stdlib.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {
  
  //----------------------------------------------------------------------------------------
  //  MNamedObject
  //----------------------------------------------------------------------------------------
  MNamedObject::MNamedObject() {
    m_ParamList = new MParameterObjectList(this);

    addInput(&*m_ParamList);
    
    setFlag(OBJECTFLAG_VISIBLE | OBJECTFLAG_CHANNELEXPAND);
    
    m_DependantList = NULL;
    
    setObjectType(OBJECTFLAG_TYPE_HELPER);
    
    addParameter(new MUniqueNameParameter(this, "Name", "Name", "Name"));
    setParamByName("Name", "Object");
  }
  
  MNamedObject::~MNamedObject() {
    m_DependantList = NULL;
    m_ParamList->deleteAllParams();
	m_ParamList = NULL;
  }
  
  MBaseObjectPtr MNamedObject::createNew() {
    MBaseObjectPtr NewObj;
    
    NewObj = new MNamedObject();
    NewObj->setFrom(this);
    
    return NewObj;
  }
  
  void MNamedObject::setFrom(MBaseObjectPtr SrcObj) {
    MBaseObject::setFrom(SrcObj);

    MNamedObjectPtr namedObj = AZTEC_CAST(MNamedObject, SrcObj);

    if (namedObj != NULL) {
      m_ParamList->setFromList(namedObj->m_ParamList);
    }
  }
  
  void MNamedObject::setName(LPCTSTR Name) {
    MStr  N;
    N = Name;
    N = Name;
    N.RemoveTrailing(' ');
    N.RemoveLeading(' ');
    
    setParamByName("Name", N);
  }
  
  MStr MNamedObject::getName() {
    return getParamByName("Name");
  }

  int MNamedObject::addDependant(MBaseObjectPtr Obj)
  {
    if (m_DependantList == NULL)
    {
      m_DependantList = new MBaseObjectList;
    }
    
    MBaseObjectListPtr DependList;
    
    DependList = AZTEC_CAST(MBaseObjectList, m_DependantList);
    
    return (DependList->addTail(Obj) != NULL);
  }
  
  int MNamedObject::removeDependant(MBaseObjectPtr Obj) {
    if (m_DependantList == NULL) {
      m_DependantList = new MBaseObjectList;
    }
    
    MBaseObjectListPtr DependList;
    
    DependList = AZTEC_CAST(MBaseObjectList, m_DependantList);
    
    DependList->removeNode(DependList->findNode(Obj));
    
    return 1;
  }
  
  MBaseObjectPtr MNamedObject::getDependantList() {
    MBaseObjectListPtr dependList;
    if (m_DependantList != NULL) {
      dependList = AZTEC_CAST(MBaseObjectList, m_DependantList->createNew());
    } else {
      dependList = new MBaseObjectList;
    }

    // loop over our parameters and see if any of them 
    // are object parameters
    MObjectParameterPtr objParam;

    for (int i = 0; i < m_ParamList->getNumParams(); ++i) {
      objParam = AZTEC_CAST(MObjectParameter, m_ParamList->getParameter(i));
      if (objParam != NULL) {
        dependList->addTail(objParam->getValue());
      }
    }

    return dependList;
  }
  
  void MNamedObject::setObjectType(AztecFlags Type) {
    unsetFlag(OBJECTFLAG_TYPE_ALL);
    setFlag(Type);
  }
  
 
  int MNamedObject::addParameter(MParameterObjectPtr ParamObj) {
    return m_ParamList->addParam(ParamObj);
  }
  
  int MNamedObject::replaceParamObject(const MStr &Name, MParameterObjectPtr Param) {
    return m_ParamList->replaceParamObject(Name, Param);
  }
  
  
  MParameterObjectPtr MNamedObject::findParameter(const MStr ParamName) {
    MParameterObjectPtr Obj;
    
    Obj = m_ParamList->getParameter(ParamName);
    
    return Obj;
  }
  
  MParameterObjectListPtr MNamedObject::getParamList() {
    return m_ParamList;
  }
  
  int MNamedObject::setParamByName(const MStr &ParamName, const MStr &Value, bool SetKey) {
    MParameterObjectPtr ParamObj;
    ParamObj = findParameter(ParamName);
    
    if (ParamObj == NULL) {
      return 0;
    }
    
    ParamObj->setValueString(Value);
    if (SetKey) {
      ParamObj->createKeyAt(getTime());
    }

    return 1;
  }
  
  int MNamedObject::getParamByName(const MStr &ParamName, MStr &Value) {
    MParameterObjectPtr ParamObj;
    ParamObj = findParameter(ParamName);
    
    if (ParamObj == NULL) {
      return 0;
    }
    
    return ParamObj->getValueString(Value);
  }
  
  MStr MNamedObject::getParamByName(const MStr &ParamName) {
    MParameterObjectPtr ParamObj;
    MStr              Value;
    
    ParamObj = findParameter(ParamName);
    
    if (ParamObj == NULL) {
      return Value;
    }
    
    ParamObj->getValueString(Value);
    return Value;
  }
  
  MVector3 MNamedObject::getParamVec(const MStr &ParamName) {
    MParameterObjectPtr Param;
    
    Param = findParameter(ParamName);
    if (Param != NULL) {
      MVector3 result;
      Param->getValueVector(result);
      return result;
    }
    
    return MVector3(0,0,0);
  }
  
  float MNamedObject::getParamFloat(const MStr &ParamName) {
    MParameterObjectPtr Param;
    
    Param = findParameter(ParamName);
    
    if (Param != NULL) {
      float result;
      Param->getValueFloat(result);
      return result;
    }
    
    return 0;
  }
  
  int MNamedObject::getParamInt(const MStr &ParamName) {
    MParameterObjectPtr Param;
    
    Param = findParameter(ParamName);
    
    if (Param != NULL) {
      int result;
      Param->getValueInteger(result);
      return result;
    }
    
    return 0;
  }

  MScriptingSupportPtr MNamedObject::getScriptObject()
  {
	  // The default scripting support for a Named object is the generic (non-functional)
	  // scripting wrapper.
	  return new MScriptingSupport();
  }



}
