// HelperFuncs.cpp
// -----------------------------------------
// Just some assorted functions or macros to assist in stuff
#include "StdAfx.h"

#include "HelperFuncs.h"
#include "string.h"
#include "time.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAX_BUFFERSIZE     65536

char  g_TextBuffer[MAX_BUFFERSIZE];

char* instructions[]={"a0103e8","a020019","a030000","7040001","2040303","1010104"};

#ifdef WIN32 

void AddLineToEdit(HWND hWnd, MStr &Str)
{
	AddLineToEdit(hWnd, Str.c_str());
}

void AddLineToEdit(HWND hWnd, const char *Str)
{
	int	Result, Length;

	Length = GetWindowTextLength(hWnd);
//	if (Length == 0)
//		return;

	Length +=  strlen(Str) + 1;

	Result = GetWindowText(hWnd, g_TextBuffer, Length-1);

	if (Result == 0)
	{
		DWORD err;
		err = GetLastError();
		if (err != 0)		// Only return if there is an error
      {
			return;
      }
	}

	strcat(g_TextBuffer, Str);
	strcat(g_TextBuffer, "\r\n");

   Result = ::SendMessage(hWnd, WM_SETTEXT, 0, (long)g_TextBuffer);
//	Result = SetWindowText(hWnd, Buffer);
	if (Result == 0)
	{
		DWORD err;
		err = GetLastError();
	}

	int NumLines = SendMessage(hWnd, EM_GETLINECOUNT,0,0);
	SendMessage( hWnd, EM_LINESCROLL, 0 , NumLines);
//	SendMessage(hWnd, WM_VSCROLL, SB_BOTTOM << 8, NULL);

//	Not allowed to delete the buffer for some reason. Possible memory leak, but 
//	deletion just doesn't work. ?!?!??!?!
}

#endif

DWORD StrToDWORD(const char *Str)
{
	DWORD *dwPtr;

	dwPtr = (DWORD*)Str;

	return *dwPtr;
}

MTimeObj::MTimeObj()
{
	GetCurrentTime();
}

void MTimeObj::GetCurrentTime()
{
	time(&m_Time);
	m_LocalTime = localtime(&m_Time);
}

MStr MTimeObj::Format(const MStr &FormatStr)
{
	char Str[128];
	char *Fmt;
	MStr	FmtCopy;

	FmtCopy = FormatStr;
	Fmt = FmtCopy.GetBuffer(1);

	strftime(Str, 128, Fmt, m_LocalTime);
	return Str;
}


void XYFromDWORD(DWORD lParam, int &x, int &y)
{
   x = LOWORD(lParam);
   y = HIWORD(lParam);

   if (x > 32768)
      x = x - 65536;
   if (y > 32768)
      y = y - 65536;
}


void XYFromDWORD(DWORD lParam, POINT *P)
{
   int x,y;
   x = LOWORD(lParam);
   y = HIWORD(lParam);

   if (x > 32768)
      x = x - 65536;
   if (y > 32768)
      y = y - 65536;
   P->x = x;
   P->y = y;
}


/*
 * There is no standard way for of using _splitfile() for Windows and Linux both.
 * So we are going to create our own function to take care of this for us.
 *
 */
void MSplitPath(const char *path, char *drv, char *dir, char *fname, char *ext)
{
      char ch, *ptr, *p;

      // convert slashes to backslashes for searching       
      for (ptr = (char *)path; *ptr; ++ptr)
      {
            if ('/' == *ptr)
                  *ptr = '\\';
      }

      // look for drive spec                                
      if (NULL != (ptr = strchr(path, ':')))
      {
            ++ptr;
            if (drv)
            {
                  strncpy(drv, path, ptr - path);
                  drv[ptr - path] = NUL;
            }
            path = ptr;
      }
      else if (drv)
            *drv = NUL;
      
      // find rightmost backslash or leftmost colon 
      if (NULL == (ptr = strrchr(path, '\\')))
            ptr = (strchr(path, ':'));

      if (!ptr)
      {
            ptr = (char *)path; // obviously, no path 
            if (dir)
                  *dir = NUL;
      }
      else
      {
            ++ptr;    // skip the delimiter 
            if (dir)
            {
                  ch = *ptr;
                  *ptr = NUL;
                  strcpy(dir, path);
                  *ptr = ch;
            }
      }

      if (NULL == (p = strrchr(ptr, '.')))
      {
            if (fname)
                  strcpy(fname, ptr);
            if (ext)
                  *ext = NUL;
      }
      else
      {
            *p = NUL;
            if (fname)
                  strcpy(fname, ptr);
            *p = '.';
            if (ext)
                  strcpy(ext, p);
      }
}

