#ifndef Aztec_MTranslator_Header
#define Aztec_MTranslator_Header

#include <ModelGeneric.h>

namespace Aztec {
  class MTranslator;
  typedef MRefCountedPtr<MTranslator> MTranslatorPtr;
}

#include <MNamedObject.h>

// Scene translators are the basis for any complex geometry or higher level files. 
// this includes any Geometry that has animation.
namespace Aztec {
  
  class MGENEXPORT MTranslator : public MRefCountedObject {
  public:
    virtual MTranslatorPtr createNew() const = 0;
    /**
     * This gets the filter used to match files that a translator can use. It should be of the form *.extension
     */
    virtual std::string getFilter() = 0;

    /**
     * Gets a description of this translator that an end user can understand.
     */
    virtual std::string getFilterDescription() = 0;

    virtual bool canImport();
    virtual bool canExport();
    virtual bool canImportFile(MStr Filename);

    // Make sure that implementing classes implement the get class name method
    // MBaseObject methods
    virtual MStr getClassName() = 0;
  };
  
}
#endif
