#ifndef MVector3KeyParameter_Header
#define MVector3KeyParameter_Header

#include "MKeyParameter.h"
#include <params/MFloatKeyParameter.h>
#include "MVector3Parameter.h"
#include "MVector3KeyList.h"

namespace Aztec {
  
  class MVector3KeyParameter;

  typedef MRefCountedPtr<MVector3KeyParameter> MVector3KeyParameterPtr;

  //---------------------------------------
  //  MVector3KeyParameter
  //---------------------------------------
  class MGENEXPORT MVector3KeyParameter : public virtual MKeyParameter, public virtual MVector3Parameter {
  public:
    /**
     * This gets the MVector3Value that the key parameter uses for storage.
     */
    virtual MVector3ValuePtr getVector3Value() = 0;

    /**
     * This creates a key just for the X component.
     *
     * @param time The time to create the key at.
     */
    virtual void createXKeyAt(long time) = 0;

    /**
     * This creates a key just for the Y component.
     *
     * @param time The time to create the key at.
     */
    virtual void createYKeyAt(long time) = 0;

    /**
     * This creates a key just for the Z component.
     *
     * @param time The time to create the key at.
     */
    virtual void createZKeyAt(long time) = 0;


    /**
     * Gets the MFloatKeyParameter for the X component.
     */
    virtual MFloatKeyParameterPtr getXParameter() = 0;

    /**
     * Gets the MFloatKeyParameter for the Y component.
     */
    virtual MFloatKeyParameterPtr getYParameter() = 0;
    
    /**
     * Gets the MFloatKeyParameter for the Z component.
     */
    virtual MFloatKeyParameterPtr getZParameter() = 0;
  };
  
  class MGENEXPORT MVector3KeyParameterImpl : public virtual MVector3KeyParameter,
                                              public MVector3ParameterImpl {
  public:
    MVector3KeyParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "", int meaning = MEANING_ANY);
    ~MVector3KeyParameterImpl();

    // MVector3KeyParameter methods
    MVector3ValuePtr getVector3Value();
    void createXKeyAt(long time);
    void createYKeyAt(long time);
    void createZKeyAt(long time);

    MFloatKeyParameterPtr getXParameter();
    MFloatKeyParameterPtr getYParameter();
    MFloatKeyParameterPtr getZParameter();

    // MVector3Parameter methods
    MVector3 getValue();
    MVector3 getValue(long time);

    // MKeyParameter methods
    MKeyableValuePtr getKeyableValue();

    // MParameterObject methods.
    bool setValueVector(const MVector3 &value);
    bool createKeyAt(long time = 0);
    bool setFromParameter(MParameterObjectPtr src);
    MParameterObjectPtr createCopy();

    // MBaseObject methods
    bool doUpdateObject();
    
  protected:
//    MVector3KeyListPtr m_Vector3KeyList;
    MVector3KeyableValuePtr m_Vector3KeyList;

    /**
     * This vector is used to store vales that were retrieved at a specific
     * time, rather than the current time.
     */
    MVector3 m_TempVal;

    void getValueFromTime(long time);
  };

}

#endif
