#ifndef MIntParameter_Header
#define MIntParameter_Header

#include <ModelGeneric.h>

namespace Aztec {
  
  class MIntParameter;
  typedef MRefCountedPtr<MIntParameter> MIntParameterPtr;

}

#include <MParameterObject.h>

#include <MBaseUndoNode.h>

namespace Aztec {

  //---------------------------------------
  //  MIntParameter
  //---------------------------------------
  class MGENEXPORT MIntParameter : public virtual MParameterObject {
  public:
    virtual int getValue() = 0;

  protected:
    MIntParameter() {
    }
    ~MIntParameter() {
    }
  };

  class MGENEXPORT MIntParameterAdapter : public virtual MIntParameter {
  public:
    // MParameterObject methods.
    int getDataType() const { return TYPE_INTEGER; }
    int getDataMeaning() const { return MEANING_ANY; }

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    MParameterObjectPtr createCopy();
  };
  
  class MGENEXPORT MIntParameterImpl : public virtual MIntParameterAdapter, 
                                       public MParameterObjectImpl {
  private:
    int    m_Value;

    class Undo : public MBaseUndoNode {
    public:
      Undo(MIntParameterImpl *param);

      MUndoableObject* getObject();
      void undo();
      void redo();

    private:
      int stored;
      MRefCountedPtr<MIntParameterImpl> object;
    };

    MRefCountedPtr<Undo> intUndo;

    friend class Undo;
    
  public:
    MIntParameterImpl(const MStr &shortName = "", const MStr &longName = "", const MStr &friendlyName = "");
    virtual ~MIntParameterImpl();

    // MIntParameter methods
    int getValue();

    // MParameterObject methods
    bool setValueInteger(int value);
    
    // MBaseObject methods
    MStr getClassName() { return MStr("MIntParameter"); }

    // MUndoableObject methods
    void finishWithUndoNode();
  };
  
}

#endif
