#ifndef MTriangleArrayParam_Header
#define MTriangleArrayParam_Header

#include <MMesh.h>
#include <MEditableMesh.h>
#include <params/MArrayParameter.h>
#include <params/MParameterFactory.h> 

#include <vector>

namespace Aztec {
  
  class MeshTriangleIndex : public MIntParameter {
  public:
    MeshTriangleIndex(MMesh *mesh, int triIndex, int vertIndex);

    // MIntParameter methods
    int getValue();

    // MParameterObject methods
    int getDataType() const;
    int getDataMeaning() const;
    MStr getShortName() const;
    MStr getLongName() const;
    MStr getFriendlyName() const;
    MBaseObject* getOwner() const;
    void setOwner(MBaseObject *newOwner);
    bool isInputParameter();
    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);
    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);
    bool createKeyAt(long time);
    bool setFromParameter(MParameterObjectPtr src);
    bool isConnectable();
    bool isConnected();
    bool setInputParameter(const MParameterObjectPtr &input);
    MParameterObjectPtr getInputParameter();
    MParameterObjectPtr createCopy();

  private:
    MMesh *mesh;
    MEditableMesh *editMesh;

    unsigned int triangleIndex  : 29;
    unsigned int vertexIndex    : 2;
    bool editMeshCheckDone      : 1;

    bool isEditableMesh();
  };

  class MeshTriangleElement : public MAggregateParameter {
  public:

    MeshTriangleElement(MMesh *mesh, int index);

    // MAggregateParameter methods
    int getMemberCount();
    MParameterObjectPtr getMember(int index);
    MStr getMemberName(int index);
    int getMemberIndex(const MStr &name);

    // MParameterObject methods
    int getDataType() const;
    int getDataMeaning() const;
    MStr getShortName() const;
    MStr getLongName() const;
    MStr getFriendlyName() const;
    MBaseObject* getOwner() const;
    void setOwner(MBaseObject *newOwner);
    bool isInputParameter();
    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);
    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool createKeyAt(long time);
    bool setValueParameter(const MParameterObjectPtr &src);

    bool setFromParameter(MParameterObjectPtr src);

    bool isConnectable();
    bool isConnected();
    bool setInputParameter(const MParameterObjectPtr &input);
    MParameterObjectPtr getInputParameter();

    MParameterObjectPtr createCopy();

  private:
    MMesh *mesh;
    MEditableMesh *editMesh;

    int triangleIndex      : 31;
    bool editMeshCheckDone : 1;

    bool isEditableMesh();

    static std::vector<MStr> memberNames;
  };

  class MTriangleArrayParam : public virtual MArrayParameterAdapter,
                              public MParameterObjectImpl {
  public:
    MTriangleArrayParam( MMesh *mesh ) ;
    ~MTriangleArrayParam();

    // ParameterObjectImpl methods

    // MArrayParameter methods
    int getElementCount();
    int addElement();
    void removeElement(int index);
    void resize(int index);
    MParameterObjectPtr getElement(int index);
    int getElementType() const;

    // MParameterObject methods
    int getDataMeaning() const;
    MBaseObject* getOwner() const;
    void setOwner(MBaseObject *newOwner);
    bool isInputParameter();
    bool createKeyAt(long time);
    MParameterObjectPtr createCopy();
    bool setValueParameter(const MParameterObjectPtr &src);

  protected:
    MMesh *mesh;
    MEditableMesh *editMesh;

    bool editMeshCheckDone;

    bool isEditableMesh();
  };

}



#endif