
#ifndef MODELGENERIC_H
#define MODELGENERIC_H

const char MODEL_API_VERSION[] = "MA02";

#ifdef WIN32

  // --- Win32 ---

  // take out warning 4251 for now
  #pragma warning(disable : 4251)

  // disable 'debug name is longer than 255 chars'
  #pragma warning(disable : 4786)

  // dominance warning mesage
  #pragma warning(disable : 4250)


  #ifdef _MGENBUILD
    #define MGENEXPORT __declspec(dllexport)
  #else
    #define MGENEXPORT __declspec(dllimport)
  #endif

#else

  // --- Linux x86 ---

  // TODO: Change if GCC requires a symbol defined for .so purposes.
  #define MGENEXPORT

  // Windows defines this for every debug build, but there's no such
  // thing on Linux, so we're defining it here.
  // TODO: Currently all builds are debug builds, have to check the
  //       --enable-debug stuff from the configure script and enable
  //       or disable it according to the users preference.
  #define _DEBUG

  /**
   * The __stdcall keyword is a MS specific keyword.
   * Rumours are saying that GCC 3.4 will have this keyword built
   * in, that's why I'm checking if it's already defined.
   */
  #ifndef __stdcall
    #define __stdcall __attribute__((__stdcall__))
  #endif

#endif


#include "MRefCountedPtr.h"

#endif

