#ifndef MVector3Value_Header 
#define MVector3Value_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MVector3Value;
  typedef MRefCountedPtr<MVector3Value> MVector3ValuePtr;

}

#include "MValue.h"
#include "MMath.h"

namespace Aztec {

  /**
   * This is an interface class for a list of Keys. Each type
   * of key list implements this interface.
   */
  class MGENEXPORT MVector3Value : public virtual MValue {
  public:

    /**
     * This gets the value of this vector3 at the given time.
     */
    virtual MVector3 getValueAtTime(long time) = 0;
  };
  

}

#endif 
