#ifndef MVector3KeyList_Header 
#define MVector3KeyList_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MVector3KeyList;
  typedef MRefCountedPtr<MVector3KeyList> MVector3KeyListPtr;

}

#include "MVector3KeyableValue.h"
#include "MFloatKeyList.h"

namespace Aztec {

  /**
   * This key list isn't really a key list, but just a container of
   * three float key lists.
   */
  class MGENEXPORT MVector3KeyList : public MVector3KeyableValue {
  public:
    MVector3KeyList();
    virtual ~MVector3KeyList();

    // MVector3KeyableValue methods
    void setInitialValue(const MVector3 &value);
    void setKey(const MVector3 &value, long time);
    void setXKey(float value, long time);
    void setYKey(float value, long time);
    void setZKey(float value, long time);
    MFloatKeyableValuePtr getXValue();
    MFloatKeyableValuePtr getYValue();
    MFloatKeyableValuePtr getZValue();

    // MKeyableValue methods
    bool hasKeySet(long time);
    void shiftKeys(long onOrAfterTime, long beforeTime, long amount);
    void shiftSelectedKeys(long amount);
    void getKeyTimes(std::vector<int> &keyTimes);
    void getSelectedKeyTimes(std::vector<int> &keyTimes);
    void deleteKey(long time);
    void deleteSelectedKeys();
    bool hasKeys();

    // MVector3Value methods
    MVector3 getValueAtTime(long time);

    // MValue methods
    bool copyFromValue(MValuePtr source);
    void storeValue();
    void restoreValue();

    // MBaseObject methods
    MStr getClassName() {return MStr("MVector3KeyList");}
    MStr getParentClassName() {return MStr("MKeyList");}
    MBaseObjectPtr createNew();

  private:
    MFloatKeyListPtr xList;
    MFloatKeyListPtr yList;
    MFloatKeyListPtr zList;
  };
  

}

#endif 
