#ifndef MVector3Key_Header
#define MVector3Key_KeyHeader

#include "ModelGeneric.h"

namespace Aztec {
  class MVector3Key;
  typedef MRefCountedPtr<MVector3Key> MVector3KeyPtr;
}

#include "MKey.h"

namespace Aztec {

  /**
   * This is an interface class that defines how Vector3Key types must operate
   */
  class MGENEXPORT MVector3Key : public MKey {
  public:
    /**
     * This gets the value of the key
     */
    virtual MVector3 getValue() = 0;
    
    /**
     * Sets the value of the key
     */
    virtual void setValue(const MVector3 &value) = 0;
    
    /**
     * Returns the tangent of the key on its way in to this key
     */
    virtual MVector3 getInTangent() = 0;
    
    /**
     * Returns the tangent of the key on its way out from this key
     */
    virtual MVector3 getOutTangent() = 0;

    /**
     * This attempts to set the incoming tangent for the key.
     * This may not be possible as the tangents may be locked.
     */
    virtual void setInTangent(const MVector3 &in) = 0;

    /**
     * This attempts to set the outgoing tangent for the key.
     * This may not be possible as the tangents may be locked.
     */
    virtual void setOutTangent(const MVector3 &out) = 0;
  };
  

}

#endif 
