#ifndef MStr_Header
#define MStr_Header

#include <string.h>
#include <string>

#include "ModelGeneric.h"

#include "MBasicTypes.h"

/**
 * This is a simple, and ineficcient implemtation of a string class.
 * It was originally meant as a MFC-independant replacement for CString
 * but it has really outlived its usefulness in its current form,
 * and desparately needs some changes and some updating.
 */
class MGENEXPORT MStr {
public:
  char		*m_String;
  
  MStr();
  MStr(const MStr &Src);
  MStr(const char *Src);
  MStr(const char Src);
  MStr(const long Src);
  MStr(const std::string &str);
  virtual ~MStr();
  
  int GetLength() const;
  
  MStr& operator=(const MStr &Src);
  MStr& operator=(LPCTSTR Src);
  MStr& operator=(char Src);
  
  MStr& operator+=(const MStr &Src);
  
  int operator==(const MStr &RHS);
  int operator==(LPCTSTR RHS);
  int operator!=(const MStr &RHS) const;
  int operator!=(LPCTSTR RHS) const;
  char& operator[](int Index);
  operator LPCTSTR() const {return c_str();}
  
  bool operator<(const MStr &rhs) { return strcmp(m_String, rhs.m_String) == -1; }
  
  int compareNoCase(const MStr &Src) const;
  
  char* GetCharPtr() { return m_String;};
  char* GetBuffer(int n = 1) { return m_String;};
  void ReleaseBuffer() { };

  const char* c_str() const { return m_String == NULL ? "" : m_String;}
  
  void Replace(char Find, char Rep);
  MStr& Format(const char *FormatStr, ...);
  /**
   * Separate this string into a number of string, separating by spaces, tabs, or whitespace
   * Returns number of params processed
   */
  int Separate(MStr *DestArray, int MaxParams) const;
  MStr& RemoveLeading(char C);
  MStr& RemoveTrailing(char C);
  
  long ToInt() const;
  float ToFloat() const;
  DWORD ToDWORD() const;
  MStr& FromBinary(DWORD Val, int MinDigits = 32);

  int SplitPath(MStr *Drive, MStr *Path, MStr *File, MStr *Ext) const;

  /**
   * returns the index of the first character that 
   * the substring occurs at. Returns -1 if nothing is found.
   */
  int findSubstring(const MStr &sub);

  /**
   * Converts this string to a lower case string.
   *
   * @return a reference to this string.
   */
  MStr& toLower();

  /**
   * Converts this string to an upper case string.
   *
   * @return a reference to this string.
   */
  MStr& toUpper();
  
};

MGENEXPORT MStr operator+(const MStr &Left, const MStr &Right);

namespace Aztec {

  MGENEXPORT bool strToBool(const MStr &value);
  MGENEXPORT MStr boolToStr(bool value);

  MGENEXPORT float strToFloat(const MStr &value);
  MGENEXPORT MStr floatToStr(float value);

  MGENEXPORT int strToInt(const MStr &value);
  MGENEXPORT MStr intToStr(int value);
}

#endif
