#if !defined(INIFILE_H)
#define INIFILE_H

#ifdef WIN32
#pragma warning( disable : 4786 )
#endif

#include <ModelGeneric.h>

#include <fstream>
#include <string>
#include <map>

namespace Aztec {

  typedef std::string CIniString;

  class MGENEXPORT CIniFile  
  {
  private:
	  /// A key is a list of name/value pairs
    class CSection : public std::map< CIniString, CIniString > { };

	  /// Each section in an ini file contains a set of keys.
    class CIniSections : public std::map< CIniString, CSection > { };

	  CIniSections iniSections;

	  //stores pathname of ini file to read/write
	  std::string path;

	  // Temporary variable allowing iteration through a section.  Only valid
	  // after a true result from StartSectionIteration(...).
    CIniSections::iterator currentSectionIt;
	  CSection::iterator sectionIt;

	  //overloaded to take CIniString
	  std::ifstream &getline(std::ifstream &is, CIniString &str);

  public:
	  //will contain error info if one occurs
	  //ended up not using much, just in ReadFile and GetValue
	  CIniString error;

	  //default constructor
	  CIniFile();

	  //constructor, can specify pathname here instead of using SetPath later
	  CIniFile(const CIniString &inipath);

	  //default destructor
	  virtual ~CIniFile();

	  //sets path of ini file to read and write from
	  void SetPath(const CIniString &newpath);

	  //reads ini file specified using CIniFile::SetPath()
	  //returns true if successful, false otherwise
	  bool ReadFile();

	  //writes data stored in class to ini file
	  void WriteFile(); 

	  //deletes all stored ini data
	  void Reset();

	  //returns number of keys currently in the ini
	  int GetNumKeys();

	  //returns number of values stored for specified key
	  int GetNumValues(const CIniString &keyname);

    // Does the value in the key exist?
    bool ValueExists(const CIniString &keyname, const CIniString &valuename);

	  // Get the value for a given key, within a given section.
	  CIniString GetValue(const CIniString &keyname, const CIniString &valuename); 
	  int GetValueI(const CIniString &keyname, const CIniString &valuename); 
	  double GetValueF(const CIniString &keyname, const CIniString &valuename);

	  // Set a key/value pair within a given section
	  bool SetValue(const CIniString &key, const CIniString &valuename, const CIniString &value, bool create = 1);
	  bool SetValueI(const CIniString &key, const CIniString &valuename, int value, bool create = 1);
	  bool SetValueF(const CIniString &key, const CIniString &valuename, double value, bool create = 1);

	  // Remove a key from a section
	  bool DeleteValue(const CIniString &keyname, const CIniString &valuename);

	  // Remove an entire section
	  bool DeleteKey(const CIniString &keyname);

    void startSectionIteration(const CIniString &key);
    bool getNextSectionValue(CIniString &valueName, CIniString &value);

  };

}
#endif // !defined(INIFILE_H)
