#include <AztecGUICommonPCH.h>
#include <gui/MOpenFileDialog.h>

namespace Aztec {
  MOpenFileDialog::MOpenFileDialog() {
    multipleSelect = false;
  }

  void MOpenFileDialog::setMultipleSelect(bool multipleSelect) {
    this->multipleSelect = multipleSelect;
  }

  void MOpenFileDialog::getFilenames(std::vector<std::string> &filenames) {
    filenames = this->filenames;
  }

  void MOpenFileDialog::setupOFN(OPENFILENAME &ofn) {
    MFileDialog::setupOFN(ofn);

    ofn.Flags |= OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;

    if (multipleSelect) {
      ofn.Flags |= OFN_ALLOWMULTISELECT;
    }
  }

  BOOL MOpenFileDialog::showDialog(OPENFILENAME &ofn) {
    return GetOpenFileName(&ofn);
  }

  void MOpenFileDialog::extractFilename(OPENFILENAME &ofn) {
    path = ofn.lpstrFile;
    filename = path.substr(ofn.nFileOffset);
    path = path.substr(0, ofn.nFileOffset);

    // now go over the filename buffer, and extract all the filenames and place them in an array.
    // TODO: do it properly.
    filenames.resize(1);
    filenames[0] = ofn.lpstrFile;
  }

  int MOpenFileDialog::getWindowsFilters(std::string &ofnFilters) {
    int count = 0;
    ofnFilters = "";

    std::string knownFilters;

    // with this, we first fill up the string with |'s as separators, and 
    // then replace those with nulls. We do this for debugging purposes, 
    // so it is easier to see the filters before they are placed in the string.

    for (unsigned int i = 0; i < filters.size(); ++i) {
      ofnFilters += filters[i].first + " (" + filters[i].second + ")";
      ofnFilters += '|';
      ofnFilters += filters[i].second;
      ofnFilters += '|';


      // now add on our known filters.
      if (knownFilters.length() > 0) {
        knownFilters += ';';
      }

      knownFilters += filters[i].second;

      ++count;
    }

    // Add in the all files and all known files filter.
    ofnFilters += "All Known Files (";
    ofnFilters += knownFilters;
    ofnFilters += ")";
    ofnFilters += '|';
    ofnFilters += knownFilters;
    ofnFilters += '|';
    ofnFilters += "All Files (*.*)|*.*||";

    count += 2;


    // now go and replace all the |'s with nulls.
    for (unsigned int i = 0; i < ofnFilters.size(); ++i) {
      if (ofnFilters[i] == '|') {
        ofnFilters[i] = '\0';
      }
    }

    return count;
  }



}

