#include <AztecGUICommonPCH.h>

#include "gui/win32/MMenuItemImpl.h"
#include <gui/win32/MAppImpl.h>

#include <config/UIConfig.h>

namespace Aztec {

  const std::string MMenuItem::SEPARATOR = "|";

  MMenuItem::MMenuItem(const std::string &caption, const std::string &command, const MMenuPtr &submenu) {
    init(caption, command, submenu);
  }

  MMenuItem::MMenuItem(const std::string &caption, const MMenuPtr &submenu) {
    init(caption, "", submenu);
  }


  MMenuItem::~MMenuItem() {
    MApp::getInstance()->unregisterMenu(this);
  }

  MENUITEMINFO MMenuItem::createMenuInfo() {
    MENUITEMINFO  info;

    info.cbSize = sizeof(MENUITEMINFO);
    info.fMask = MIIM_CHECKMARKS | MIIM_ID | MIIM_STATE | MIIM_TYPE | MIIM_DATA | MIIM_SUBMENU;
    info.fType = m_Separator ? MFT_SEPARATOR : MFT_STRING;
    info.fState = (m_Enabled ? MFS_ENABLED : MFS_DISABLED) | (m_Checked ? MFS_CHECKED : 0) ;
    info.wID = m_ID;
    info.hSubMenu = (m_SubMenu != NULL) ? m_SubMenu->getHMenu(true) : NULL;
    info.hbmpChecked = NULL;
    info.hbmpUnchecked = NULL;
    info.dwItemData = NULL;
    info.dwTypeData = (char*)m_Caption.c_str();
    info.cch = m_Caption.length();

    return info;
  }

  bool MMenuItem::setMenuItemInfo() {
    if (m_Parent == NULL || m_Parent->getHMenuNoCreate() == NULL) {
      return false;
    }

    BOOL result;
    MENUITEMINFO info = createMenuInfo();

    result = ::SetMenuItemInfo(m_Parent->getHMenu(), m_Position, TRUE, &info);

    return (result == TRUE);
  }

  unsigned short MMenuItem::getID() { 
    return m_ID; 
  }

  unsigned short MMenuItem::getOptionID() { 
    return m_OptionID; 
  }

  void MMenuItem::setParent(MMenu *p) { 
    m_Parent = p; 
  }

  MMenu* MMenuItem::getParent() { 
    return m_Parent; 
  }

  void MMenuItem::doClick() {
    if (!onClick()) {
      getParent()->onItemClick(this);
    }
  }

  bool MMenuItem::isSeparator() {
    return m_Separator;
  }

  // MComponentImpl methods
  bool MMenuItem::createImpl() {
    // do nothing here as we don't need to create
    // a window here at all.
    return true;
  }

  void MMenuItem::setCaption(const std::string &caption) {
    m_Caption = caption;

    setMenuItemInfo();
  }

  std::string MMenuItem::getCaption() {
    return m_Caption;
  }

  void MMenuItem::setCommand(const std::string &command) {
    m_Command = command;
  }

  std::string MMenuItem::getCommand() {
    return m_Command;
  }

  void MMenuItem::setOptionCommand(const std::string &command) {
    m_OptionCommand = command;
  }

  std::string MMenuItem::getOptionCommand() {
    return m_OptionCommand;
  }

  void MMenuItem::setChecked(bool isChecked) {
    m_Checked = isChecked;

    setMenuItemInfo();
  }

  bool MMenuItem::getChecked() {
    return m_Checked;
  }

  void MMenuItem::setEnabled(bool isEnabled) {
    m_Enabled = isEnabled;;
    setMenuItemInfo();
  }

  bool MMenuItem::getEnabled() {
    return m_Enabled;
  }

  MMenuPtr MMenuItem::getSubMenu() {
    return m_SubMenu;
  }

  void MMenuItem::setSubMenu(const MMenuPtr &menu) {
    m_SubMenu = menu;
  }


  bool MMenuItem::onClick() {
    return false;
  }

  void MMenuItem::init(const std::string &caption, const std::string &command, const MMenuPtr &submenu) {
    if (caption == SEPARATOR) {
      m_Caption = "";
      m_Separator = true;
    } else {
      m_Separator = false;
      m_Caption = caption;
    }

    m_Command = command;

    m_SubMenu = submenu;
    m_Checked = false;
    m_Enabled = true;

    m_ID = MMenu::getNewCommandID();
    m_OptionID = MMenu::getNewCommandID();

    m_Position = -1;
    m_Parent = NULL;

    // check to see if this command isn't already listed in the ui config. If it isn't, add it in.
    if (command != "") {
      std::string friendlyName = AztecGUI::UIConfig::getFriendlyName(command);
      if (friendlyName == "") {
        AztecGUI::UIConfig::addFriendlyCommand(caption, command, "Unsorted");
      }
    }

    MApp::getInstance()->registerMenu(this);
  }




}

