#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MButton.h>
namespace Aztec {

  static JSBool js_MButton_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_getCaption(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setCaption(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_getCommand(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setCommand(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_addClickListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  JSClass js_MButton_class = {
    "MButton", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMButton_methods[] = {
    // Object/mesh creation
    {"getCaption",  js_getCaption,          0},
    {"setCaption",  js_setCaption,          1},
    {"getCommand",  js_getCommand,          0},
    {"setCommand",  js_setCommand,          1},
    {"addListener", js_addClickListener,    1},
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMButtonClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MButton_class, js_MButton_constructor, 0,
      NULL, aztecMButton_methods, 0, 0);
    
    return cl;
    
  }
  
  static JSBool js_MButton_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {

    // we only accept 0, 1 or 2 arguments to a constructor.
    if (argc > 2) {
      return JS_FALSE;
    }

    std::string caption;
    std::string command;

    if (argc >= 1) {
      caption = JS_GetStringBytes(JS_ValueToString(cx, argv[0]));
    }
    if (argc >= 2) {
      command = JS_GetStringBytes(JS_ValueToString(cx, argv[1]));
    }

    MButtonPtr newComponent = new MButton(caption, command);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSBool js_getCaption(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      return JS_FALSE;
    }

    MButtonPtr button = getGuiObject<MButton>(cx, obj);
    
    if (button != NULL) {
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, button->getCaption().c_str()) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }
  
  static JSBool js_setCaption(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      return JS_FALSE;
    }
    
    MButtonPtr button = getGuiObject<MButton>(cx, obj);
    
    if (button != NULL) {
      button->setCaption( JS_GetStringBytes( JS_ValueToString(cx, argv[0]) ) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }
  

  static JSBool js_getCommand(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      return JS_FALSE;
    }

    MButtonPtr button = getGuiObject<MButton>(cx, obj);
    
    if (button != NULL) {
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, button->getCommand().c_str()) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }
  
  static JSBool js_setCommand(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      return JS_FALSE;
    }
    
    MButtonPtr button = getGuiObject<MButton>(cx, obj);
    
    if (button != NULL) {
      button->setCommand( JS_GetStringBytes( JS_ValueToString(cx, argv[0]) ) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }
  

  class JSClickListener : public MButtonListener {
  public:
    JSClickListener(JSContext *cx, JSObject *obj, JSFunction *function, uintN argc, jsval *argv) {
      this->cx = cx;
      this->func = function;
      this->object = obj;
      for (uintN i = 0; i < argc; ++i) {
        args.push_back(argv[i]);
      }
    }

    void onClick(const MButtonPtr &button) {

      jsval rval;

      jsval *argv = new jsval[args.size()];

      for (int i = 0; i < args.size(); ++i) {
        argv[i] = args[i];
      }

      JS_CallFunction(cx, object, func, args.size(), argv, &rval);

      delete[] argv;
    }

    JSContext *cx;
    JSFunction *func;
    JSObject *object;
    std::vector<jsval> args;
  };

  static JSBool js_addClickListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc < 1) {
      return JS_FALSE;
    }

    MButtonPtr button = getGuiObject<MButton>(cx, obj);
    JSFunction *func = JS_ValueToFunction(cx, argv[0]);
    
    if (func != NULL && button != NULL) {

      button->addListener(new JSClickListener(cx, obj, func, argc - 1, argv + 1));

      return JS_TRUE;
    } else {
      return JS_FALSE;
    }


    return JS_FALSE;
  }


}
