/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  2111-1307  USA

*/

#include <AztecGUICommonPCH.h>
#include <gui/MMenuBar.h>
#include <gui/MApplication.h>

#include <gui/qt3/QMenuBar_.moc>


namespace Aztec {


  MMenuBar::MMenuBar() {
  }

  MMenuBar::~MMenuBar() {
  }


  // MComponentImpl methods

  bool MMenuBar::createImpl() {
    if (m_Handle != 0l) return true;

    MApp *app;
    QWidget* parentWnd = 0l;

    // Get the parent widget handle, so we can create our menubar
    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    app = MApp::getInstance();

    // create the actual widget
    QMenuBar* mb1 = new CQMenuBar_(parentWnd, this);
    m_Handle = mb1;
    m_MenuHandle = mb1;

    // if it succeeded, update everything
    if (m_Handle != 0) {
      // Register this widget with the application
      app->registerComponent(m_Handle, this);

      // Call the create event handler
      onCreate();

      // Do NOT outcomment this visibility call,
      // It makes other windows flash (you'll understand
      // why when seeing this in action)
      //setVisible(true);

      return true;
    }

    return false;
  }

  bool MMenuBar::onPaint() {
    return true;
  }

  MSize2D MMenuBar::getMinimumSize() {
    return MSize2D(32, m_Handle->height());
  }

  bool MMenuBar::isMinimumSizeSet() {
    return true;
  }


  // MMenuShell methods

  int MMenuBar::getItemCount() {
//    return items.size();
return 0;
  }

  MMenuItemPtr MMenuBar::getItem(int index) {
//    return items[index].menuItem;
return NULL;
  }

  void MMenuBar::addItem(MMenuItemPtr item) {
    // TODO: Paranoia checks
    item->getSubMenu()->init();
    m_MenuHandle->insertItem(item->getCaption().c_str(), (QPopupMenu*)item->getSubMenu()->m_MenuHandle);
  }

  void MMenuBar::addItem(MMenuItemPtr item, int index) {
    // TODO: Implementation
  }

  void MMenuBar::addSeparator() {
    // Do nothing
  }

  void MMenuBar::addSeparator(int index) {
    // Do nothing
  }

  void MMenuBar::removeItem(int index) {
    // TODO: Implementation
  }

  bool MMenuBar::onItemClick(const MMenuItemPtr &item) {
    return false;
  }


}

