#ifndef MToolType_Header
#define MToolType_Header

// AztecGUI includes
#include <AztecGUICommon.h>
#include <gui/MComponent.h>

// AztecLib includes
#include <MNamedObject.h>
#include <MStr.h>
#include <MMath.h>
#include <MSelectionItem.h>

namespace AztecGUI {

  class MToolType;
  typedef Aztec::MRefCountedPtr<MToolType> MToolTypePtr;

  #define TOOLFLAGS_ANYOBJECT      0xffff
  #define TOOLFLAGS_POINTS         0x0001
  #define TOOLFLAGS_FACES          0x0002
  #define TOOLFLAGS_EDGES          0x0004

  #define TOOLRESULT_DRAWNONE       0
  #define TOOLRESULT_DRAWALL        1
  #define TOOLRESULT_DRAWCURRENT    2

  #include <string>

  class AZTECGUI_EXPORT MToolType : public Aztec::MRefCountedObject {
  public:
     bool m_RequiresSel, m_Dragging;
     Aztec::MFlagObject  m_SelFlags;

     Aztec::MVector3     m_DownPos, m_UpPos, m_CurPos;    // The cursor coordinates in screen space

     /// The current manipulator that is being used.
     int m_PickedManip;    

     /// Input list of objects to use for tool selection and what not.
     std::vector<Aztec::MSelectionItem> m_InputList;

     MToolType();
     virtual ~MToolType();

     virtual std::string getName() = 0;

     bool Is(MStr Str);
     bool RequiresSelection() {return m_RequiresSel;};

     /**
      * this method is called when a tool is set to be the current tool. Each 
      * tool class implements this method to initialise any data, or prepare 
      * object selections or whatever.
      */
     virtual void initialise();

     /**
      * This method is called when the user wants to finish with this tool. 
      * Implementin classes override this method to perform any actions that
      * complete the tools uasage. For example, if we are creating a spline,
      * finishing off the tool would finish up where we are and go back to 
      * object mode. If we were a bone creation tool, we would just switch back
      * to the previous tool.
      *
      * The default behaviour for this is to simply go back to the previously
      * selected tool.
      *
      * @return true If we are finished with tool, and the tool manager should
      *         revert to the previosuly used tool. False if we are not finished
      *         with this tool, and we should stay on this one.
      */
     virtual bool finish();

     /**
      * This is called by the user when they want to cancel the current action
      * being performed by the tool.
      *
      * The default behaviour for this is to go back to the previosuly selected 
      * tool.
      *
      * @return true If we are finished with tool, and the tool manager should
      *         revert to the previosuly used tool. False if we are not finished
      *         with this tool, and we should stay on this one.
      */
     virtual bool cancel();  

     /**
      * The tool should return true if the tool is doing something that calling 
      * cancel() will stop. The side effect of this should that if inProgress() 
      * reutrns true, calling cancel() should return false.
      */
     virtual bool inProgress();
   
     virtual int drawTool(bool Select, const Aztec::MComponentPtr &comp);
     virtual int onMouseDown(const Aztec::MMouseEvent &event);
     virtual int onMouseUp(const Aztec::MMouseEvent &event);
     virtual int onMouseMove(const Aztec::MMouseEvent &event);
     virtual int getDefaultManip() {return -1;};

     virtual int wrapMouse() {return 0;};

  };

}
#endif

