#ifndef MTreeControlImpl_Header
#define MTreeControlImpl_Header

#include <gui/MTreeControl.h>
#include <gui/MLayoutManager.h>

#include <string>
#include <vector>

#include <windows.h>
#include <commctrl.h>

#include <set>

namespace Aztec {

  class AZTECGUI_EXPORT MTreeControl : public virtual Aztec::IMTreeControl, public MComponent {
  public:
    MTreeControl();
    ~MTreeControl();
    
    /**
     * Gets the MTreeItem given the windows HTREEITEM. Used by MAppImpl to 
     * proces the WM_NOTIFY messages generated by the windows tree control.
     */
    MTreeItemPtr getItem(HTREEITEM hItem);

    // MTreeControl Methods
    void selectItem(const MTreeItemPtr &item, bool selected = true);

    void clear();
    MTreeItemPtr addItem(const std::string &text);
    MTreeItemPtr addItem(const std::string &text, const MTreeItemPtr &parent);

    void expandItem(const MTreeItemPtr &item, bool expand);
    bool onItemSelected(const MTreeItemPtr &item);

    // MComponentImpl methods
    bool createImpl();
    bool preTranslateMessage(MSG *msg);
    bool handleWMCommandNotify(int notifyCode, int id);
    bool handleWMNotify(WPARAM wParam, LPARAM lParam);

    // MComponent Methods

  protected:
    HTREEITEM hitTest(int x, int y, UINT *flags);
    UINT getItemState(HTREEITEM item, UINT mask);
    void setItemState(HTREEITEM item, UINT value, UINT mask);
    DWORD getItemData(HTREEITEM item);
    void SelectMultiple( HTREEITEM hClickedItem, UINT nFlags, POINT point);
    void ClearSelection();
    BOOL SelectItems( HTREEITEM hFromItem, HTREEITEM hToItem );
    void sendTVSelChanging(HTREEITEM item, const POINT &p);
    void sendTVSelChanged(HTREEITEM item, const POINT &p);


    void selectItem(HTREEITEM item, bool selected);

    void notifyChangedSelections();

    HTREEITEM clickedItem;
    HTREEITEM m_hFirstSelectedItem;
    BOOL m_bSelectPending;
    BOOL m_bSelectionComplete;
    POINT m_ptClick;

    std::set<HTREEITEM> changedItems;
  };


  class AZTECGUI_EXPORT MTreeItem : public Aztec::IMTreeItem {
  public:
    MTreeItem();
    MTreeItem(const MTreeItem &src);
    MTreeItem(HWND treeWnd, HTREEITEM treeitem);

    // IMTreeItem methods.
    std::string getText() const;
    int compare(const MTreeItemPtr &rhs);
    MTreeItemPtr getParent() const;
    bool getSelected() const;

  private:
    HWND tree;
    HTREEITEM item;

    friend class MTreeControl;

  };


}


#endif