#ifndef MOpenFileDialogImpl_Header
#define MOpenFileDialogImpl_Header

#include <gui/MOpenFileDialog.h>
#include <vector>

#include <windows.h>

namespace Aztec {

  class AZTECGUI_EXPORT MOpenFileDialog : public virtual IMOpenFileDialog, public MFileDialog {
  public:
    MOpenFileDialog();

    // MOpenFileDialog methods
    void setMultipleSelect(bool multipleSelect);
    void getFilenames(std::vector<std::string> &filenames);

  protected:
    std::vector<std::string> filenames;
    bool multipleSelect;

    // MFileDialog methods
    void setupOFN(OPENFILENAME &ofn);
    BOOL showDialog(OPENFILENAME &ofn);
    void extractFilename(OPENFILENAME &ofn);
    int getWindowsFilters(std::string &ofnFilters);
  };

}

#endif

