#ifndef MMenuImpl_Header
#define MMenuImpl_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class MMenu;
  typedef MRefCountedPtr<MMenu> MMenuPtr;

}

#include <gui/MMenu.h>
#include <gui/MMenuItem.h>
#include <gui/MMenuShell.h>

#include <vector>

#include <windows.h>


namespace Aztec {

  class AZTECGUI_EXPORT MMenu : public virtual IMMenu, public MMenuShell {
  public:
    MMenu();
    ~MMenu();

    /**
     * This gets a new command ID for a menu item to use.
     */
    static unsigned short getNewCommandID(); 

    HMENU getHMenu(bool asPopup = false);
    HMENU getHMenuNoCreate();

    void fixChildPositions();

    // MMenu Methods
    int getItemCount();
    MMenuItemPtr getItem(int index);
    void addItem(MMenuItemPtr item);
    void addItem(MMenuItemPtr item, int index);
    void addSeparator();
    void addSeparator(int index);
    void removeItem(int index);
    bool onItemClick(const MMenuItemPtr &item);
    bool popupMenu(const MComponentPtr &component, const MPoint2D &position);

  protected:
    HMENU m_hMenu;

    std::vector<MMenuItemPtr> m_Items;

    /** 
     * This is the last integer ID used 
     * when creating a menu item.
     */
    static unsigned short m_lastID;

    void updateOptionBoxes();
  };

}


#endif