#ifndef MAppImpl_Header
#define MAppImpl_Header

#include "gui/MGuiBase.h"
#include "gui/MApplication.h"
#include "gui/MWindow.h"

#include <windows.h>

#include <string>
#include <map>
#include <hash_map>
#include <set>

namespace Aztec {


#define AZTEC_USE_APP( AppClass )                                                   \
  int APIENTRY WinMain(HINSTANCE hInstance,                                         \
                       HINSTANCE hPrevInstance,                                     \
                       LPSTR     lpCmdLine,                                         \
                       int       nCmdShow)                                          \
  {                                                                                 \
    AppClass *app = new AppClass();                                                 \
    app->win32Init("appname", hInstance);                                           \
    Aztec::IMApp::Ptr appPtr = app;                                                 \
                                                                                    \
    TCHAR buf[2048];                                                                \
    GetModuleFileName(NULL, buf, 2047);                                             \
    app->appPath = buf;                                                             \
    app->appPath = app->appPath.substr(0, app->appPath.find_last_of('\\'));         \
    for (int i = 0; i < app->appPath.length(); ++i) {                               \
      if (app->appPath[i] == '\\') app->appPath[i] = '/';                           \
    }                                                                               \
                                                                                    \
                                                                                    \
	  if (!app->initApp()) {                                                          \
		  return FALSE;                                                                 \
	  }                                                                               \
                                                                                    \
    int result = app->run();                                                        \
                                                                                    \
    app->cleanup();                                                                 \
                                                                                    \
    appPtr = NULL;                                                                  \
	  return result;                                                                  \
  }
                                                                                    
  class AZTECGUI_EXPORT MApp : public virtual Aztec::IMApp {
  public:

    std::string appPath;
    
    MApp();
    ~MApp();

    static MApp* getInstance();

    void win32Init(const std::string &appName, HINSTANCE hInst);

    /**
     * This gets the HINSTANCE of this application
     */
    HINSTANCE getHInstance();

    /**
     * gets A window class to be used by non-standard windows.
     */
    ATOM getWindowClass(const std::string &name);

    /**
     * This gets a component given a HWND
     */
    MComponentPtr getComponent(HWND hWnd);

    /**
     * This registers a component to a hwnd
     */
    void registerComponent(HWND hWnd, const MComponentPtr &component);

    void unregisterComponent(HWND hWnd);

    void registerMenu(MMenuItem *item);
    void unregisterMenu(MMenuItem *item);

    MMenuItem* getItemFromID(WORD id);

    bool preTranslateMessage(MSG *msg);

    // MApp methods
    bool initApp();
    int run();
    void cleanup();
    std::string getName();
    std::string getApplicationPath();
    MWindowPtr getTopLevelWindow();
    bool onCommand(const std::string &command, const MComponentPtr &component);
    bool onMouseMove(const MMouseEvent &event);
    bool onMousePressed(const MMouseEvent &event);
    bool onMouseReleased(const MMouseEvent &event);
    bool onKeyPressed(const MKeyEvent &event);
    bool onKeyReleased(const MKeyEvent &event);

    MComponent *lastMouseMove;

  protected:
    /**
     * This is the name of the application
     */
    std::string m_Name;

    /**
     * This is the HINSTANCE of the app
     */
    HINSTANCE m_hInst;

#if _MSC_VER >= 1300
    typedef stdext::hash_map<HWND, MComponentPtr> HWNDComponentMap;
#else
    /**
     * This is a mapping from HWND's to MWindow's
     */
    class HWNDHash {
    public:
      long operator()(HWND hwnd) const {
        return (long)hwnd;
      }

    };
    typedef std::hash_map<HWND, MComponentPtr, HWNDHash > HWNDComponentMap;
#endif

    HWNDComponentMap hWndMap;

    /**
     * just a list of all the MWindow's in the application
     */
    std::map<MWindowPtr, int> allWindows;

    /**
     * This is a map from window class names to atoms.
     */
    std::map<std::string, ATOM> classMap;

    /**
     * This adds a class->ATOM map entry
     */
    bool addClass(const std::string &name, ATOM atom);

    typedef std::map<unsigned short, MMenuItem*> IDMenuItemMap;
    
    IDMenuItemMap menuItemMap;

  };


}


#endif