#ifndef AztecGuiCommon_AztecGUIScripting_Header
#define AztecGuiCommon_AztecGUIScripting_Header

#include "MRefCountedPtr.h"

#include <gui/MMouseEvent.h>
#include <gui/MSize2D.h>

extern "C" {
#define XP_PC
#include "jsapi.h"
}

namespace Aztec {

  typedef MRefCountedPtr<MRefCountedObject> JS_GUIObject;

  template <class T>
  JSBool js_generic_constructor(JSContext *cx, JSObject *obj, T *object) {
    return JS_SetPrivate(cx, obj, new MRefCountedPtr<MRefCountedObject>(object));
  }

  template <class T>
    T* getGuiObject(JSContext *cx, JSObject *obj) {
    JS_GUIObject *component = (JS_GUIObject*)JS_GetPrivate(cx, obj);
    if (component != NULL) {
      return AZTEC_CAST(T, *component);
    } else {
      return NULL;
    }
  }

  JSObject* initMComponentClass(JSContext *cx);
  JSObject* initMContainerClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMScrolledContainerClass(JSContext *cx, JSObject *containerClass);
  JSObject* initMWindowClass(JSContext *cx, JSObject *containerClass);
  JSObject* initMToolWindowClass(JSContext *cx, JSObject *windowClass);
  JSObject* initMBorderLayoutClass(JSContext *cx);
  JSObject* initMFlowLayoutClass(JSContext *cx);
  JSObject* initMGridLayoutClass(JSContext *cx);
  JSObject* initMButtonClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMTextFieldClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMLabelClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMSliderClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMCheckboxClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMComboBoxClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMTabbedContainerClass(JSContext *cx, JSObject *componentClass);
  JSObject* initMMouseEventClass(JSContext *cx);
  JSObject* initMKeyEventClass(JSContext *cx);
  JSObject* initMSize2DClass(JSContext *cx);

  void initGUIClasses(JSContext *cx);

  JSObject* createMouseEvent(JSContext *cx, JSObject *parent, const MMouseEvent &event);
  JSObject* createMSize2D(JSContext *cx, JSObject *parent, const MSize2D &event);
  JSObject* createKeyEvent(JSContext *cx, JSObject *parent, const MKeyEvent &event);

  JSObject* getJSObject(JSContext *cx, JSObject *parent, const MContainerPtr &container);
}


#endif

