
#ifndef QWindow_Header
#define QWindow_Header

#include <string>
#include <iostream>

#include <qapplication.h>
#include <qmainwindow.h>
#include <qevent.h>

#include <gui/MApplication.h>
#include <gui/MWindow.h>


/**
 * Custom QWidget class for passing signals into AztecGUI
 */
class CQWindow_ : public QMainWindow {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQWindow_(QWidget* parent, const Aztec::MWindowPtr ref)
    : QMainWindow(parent),
      m_Ref(ref) {
    // Connect the signals
    connect(this, SIGNAL(resizeEvent(QResizeEvent*)), SLOT(onResize(QResizeEvent*)));
    connect(this, SIGNAL(showEvent(QShowEvent*)), SLOT(onShow(QShowEvent*)));
    connect(this, SIGNAL(closeEvent(QCloseEvent*)), SLOT(onClose(QCloseEvent*)));
  };

  ~CQWindow_() {
    m_Ref = 0l;
  }

protected:
  /**
   * TODO: Perhaps we should do this in a filter?
   */
  void destroyed() {
    // NOTE: vtable is degenerated..
    //       Do not call any methods on this object.
    Aztec::MApp* app = Aztec::MApp::getInstance();

    if (m_Ref == app->getTopLevelWindow()) {
      // Quit
      std::cout << "QApplication::exit()" << std::endl;
      QApplication::exit();
    }

    // Call base method
    QMainWindow::destroyed();
  };

protected:
  /**
   * A reference to the MWindow that is using us
   */
  Aztec::MWindowPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  void resizeEvent(QResizeEvent* ev);
  void showEvent(QShowEvent* ev);
  void closeEvent(QCloseEvent* ev);

protected slots:
  /**
   * These methods passes the signals to AztecGUI
   */
  void onResize(QResizeEvent* ev) {
    QMainWindow::resizeEvent(ev);
    m_Ref->onResize(ev->size().width(), ev->size().height());
  };

  void onShow(QShowEvent* ev) {
    QMainWindow::showEvent(ev);
    m_Ref->onShow();
  };

  void onClose(QCloseEvent* ev) {
    //
    // Are you sure you would like to close the window?
    //
    //                [ YES ]  [ NO ]
    //
    if (m_Ref->onClose()) {
      // no
      std::cout << "ev->ignore()" << std::endl;
      ev->ignore();
    }
    else {
      // yes
      std::cout << "ev->accept()" << std::endl;
      ev->accept();
    }
  }

};


#endif

