
#ifndef MScrolledContainerImpl_Header
#define MScrolledContainerImpl_Header

#include <gui/MScrolledContainer.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT MScrolledContainer : public virtual Aztec::IMScrolledContainer, 
                                             public MContainer {
  public:
    MScrolledContainer();

    // MComponentImpl methods
    bool createImpl();

    // IMScrolledContainer methods
    void setVisibility(ScrollBarEnum scroller, VisiblityEnum visibility);
    VisiblityEnum getVisibility(ScrollBarEnum scroller);
    bool onScrolled(ScrollBarEnum scroller);

    // MComponent methods
/*    void setPosition(const MPoint2D &pos);
    void setPosition(int X, int Y);
    void setPosition(int X, int Y, int width, int height);
    MPoint2D getPosition();
    void setSize(const MSize2D &size);
    void setSize(int width, int height);
    MRect2D getWindowRect();*/
    void setWindowRect(const MRect2D &rect);
    /*MSize2D getClientSize();
    MSize2D getSize();*/

    // MContainer methods
    void addComponent(Aztec::MComponentPtr component);
    void addComponent(Aztec::MComponentPtr component, int index);
    void addComponent(Aztec::MComponentPtr component, Aztec::MConstraint constraints);
    void addComponent(Aztec::MComponentPtr component, int index, Aztec::MConstraint constraints);
    void doLayout();


    // Private (as in: not exposed through AGUI) methods
    virtual QWidget* getHandle();

  private:

    void setScrollVisible(ScrollBarEnum scroller, bool visible);

    VisiblityEnum isvisible;
    bool vertVisible;
  };

  typedef MRefCountedPtr<MScrolledContainer> MScrolledContainerPtr;
}


#endif

