#ifndef MPoint2D_Header
#define MPoint2D_Header

#include <gui/MGuiBase.h>

namespace Aztec {

  class MRect2D;

  class AZTECGUI_EXPORT MPoint2D {
  public:

    MPoint2D() : x(0), y(0) { }
    MPoint2D(int X, int Y) : x(X), y(Y) { }
    MPoint2D(const MPoint2D &src) : x(src.x), y(src.y) { }

    inline bool operator!=(const MPoint2D &rhs) {
      return (x != rhs.x) || (y != rhs.y);
    }

    inline bool operator==(const MPoint2D &rhs) {
      return (x == rhs.x) && (y == rhs.y);
    }

    inline MPoint2D operator+(const MPoint2D &rhs) {
      return MPoint2D(x + rhs.x, y + rhs.y);
    }

    inline void limitToRect(const MRect2D &rect);

    /**
     * The point's X coordinate.
     */
    int x;

    /**
     * The point's y coordinate.
     */
    int y;
  };

}

#include <gui/MRect2D.h>

namespace Aztec {
  inline void MPoint2D::limitToRect(const MRect2D &rect) {
    if (x < rect.getLeft()) {
      x = rect.getLeft();
    }
    if (x > rect.getRight()) {
      x = rect.getRight();
    }
    if (y < rect.getTop()) {
      y = rect.getTop();
    }
    if (y > rect.getBottom()) {
      y = rect.getBottom();
    }
  }
}



#endif

