#ifndef MHotKeyControl_Header
#define MHotKeyControl_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMHotKeyControl;
  class MHotKeyControl;

  typedef MRefCountedPtr<IMHotKeyControl> IMHotKeyControlPtr;
  typedef MRefCountedPtr<MHotKeyControl> MHotKeyControlPtr;

}

#include <gui/MTextField.h>
#include <gui/MShiftState.h>
#include <gui/MKeyEvent.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT IMHotKeyControl : public virtual IMTextField {
  protected:
    IMHotKeyControl() { }
    ~IMHotKeyControl() { }

  public:
    typedef IMHotKeyControlPtr Ptr;

    virtual MKeyEvent::KeyCode getHotKey() const = 0;
    virtual MShiftState getModifiers() const = 0;
    virtual void setHotKey(MKeyEvent::KeyCode code, MShiftState modifiers) = 0;
    virtual void clearHotKey() = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MHotKeyControlImpl.h>


#endif

