#ifndef Aztec_GUICommon_MCheckbox_Header
#define Aztec_GUICommon_MCheckbox_Header

#include <MRefCountedPtr.h>

namespace Aztec {

  class IMCheckbox;
  class MCheckbox;

  typedef MRefCountedPtr<IMCheckbox> IMCheckboxPtr;
  typedef MRefCountedPtr<MCheckbox> MCheckboxPtr;

}

#include <gui/MComponent.h>

#include <string>


namespace Aztec {

  /**
   */
  class AZTECGUI_EXPORT IMCheckbox : public virtual IMComponent {
  protected:
    IMCheckbox() { }
    ~IMCheckbox() { }

  public:
    class ChangeListener : public MRefCountedObject {
    public:
      virtual void onChange(const MCheckboxPtr &checkBox) = 0;
    };

    typedef MRefCountedPtr<ChangeListener> ChangeListenerPtr;

    virtual void setValue(bool value) = 0;
    virtual bool getValue() = 0;

    /**
     * This is called after the slider has been moved.
     */
    virtual bool onChanged() = 0;

    /**
     * Adds a listener to the check box, so that when the state of the checkbox changes, the listener is notified.
     */
    virtual void addListener(const ChangeListenerPtr &listener) = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MCheckboxImpl.h>


#endif

