#include <Aztec3DPCH.h>

// Aztec2 includes
#include <views/UVEditView.h>
#include <controls/UVCanvas.h>
#include <controls/ToolButton.h>
#include <gui/MBorderLayout.h>
#include <tools/MSelectTool.h>

// AztecGuiCommon
#include <tools/MToolManager.h>
#include <gui/MContainer.h>
#include <gui/MBorderLayout.h>
#include <gui/MFlowLayout.h>

// AztecLib includes
#include <scripting/MScriptInterp.h>
#include <MMesh.h>
#include <MUIManager.h>

namespace AztecGUI {

  template <typename Condition, typename Callback>
  static void iterateOverTextureMeshes(const Aztec::MScenePtr &scene, Condition condition, Callback callback) {
    scene->getObjectList()->beginIteration();
    
    Aztec::MBaseObjectPtr Obj;
    while ((Obj = scene->getObjectList()->getNext()) != NULL) {
      Aztec::MSceneObjectPtr sceneObj;
      if ((sceneObj = AZTEC_CAST(Aztec::MSceneObject, Obj)) == NULL) {
        continue;
      }
      Aztec::MMeshPtr Mesh;
      if (sceneObj->getShapeObject() != NULL) {
        Mesh = AZTEC_CAST(Aztec::MMesh, sceneObj->getShapeObject()->convertToMesh());
      }
      
      if (Mesh != NULL) {
        
        Aztec::MMeshPtr TextureMesh;
        
        TextureMesh = Mesh->getTextureMesh();
        
        if (TextureMesh != NULL) {
          if ((*condition)(sceneObj, TextureMesh)) {
            if (!(*callback)(sceneObj, TextureMesh)) {
              break;
            }
          }
        }
      }
    }
    scene->getObjectList()->endIteration();
  }

  std::string UVEditView::VIEW_GROUP = "UV";

  UVEditView::UVEditView(const std::string &name) : AztecGLView(name)
  {
    MToolManager::getInstance()->setDefault(new MSelectToolType(), getViewGroup());
  }

  UVEditView::~UVEditView() {
  }

  UVCanvasPtr UVEditView::getUVCanvas() {
    return canvas;
  }

  AztecGLCanvasPtr UVEditView::getCanvas() {
    return canvas;
  }

  void UVEditView::drawView() {
    // do drawing stuff here.
  }

  AztecViewPtr UVEditView::createCopy() {
    UVEditViewPtr result = new UVEditView(getName());

    // Copy important information about cameras and whatever else here.

    return result;
  }

  std::string UVEditView::getViewGroup() const {
    return VIEW_GROUP;
  }

  MToolTypePtr UVEditView::getSelectTool() {
    return new MSelectToolType();
  }


  void UVEditView::onCreate() {
    AztecView::onCreate();

    Aztec::MContainerPtr content = new Aztec::MContainer();
    addComponent(content, Aztec::MBorderLayout::CENTRE);
    content->setLayoutManager(new Aztec::MBorderLayout());

    canvas = new UVCanvas(this);

    Aztec::MContainerPtr toolbar = new Aztec::MContainer();
    content->addComponent(toolbar, Aztec::MBorderLayout::NORTH);
    toolbar->setLayoutManager(new Aztec::MFlowLayout());

    toolbar->addComponent(new ToolButton("Move", VIEW_GROUP, "toolMove"));
    toolbar->addComponent(new ToolButton("Rotate", VIEW_GROUP, "toolRotate"));
    toolbar->addComponent(new ToolButton("Scale", VIEW_GROUP, "toolScale"));


    content->addComponent(canvas, Aztec::MBorderLayout::CENTRE);

    canvas->setPerspective(false);
    canvas->setCameraRotation(Aztec::MVector3(0,0,0));
    canvas->setGridBasis(Aztec::MVector3(1,0,0), Aztec::MVector3(0,1,0));
  }

  bool UVEditView::selectParent() {
    return false;
  }

  bool UVEditView::selectChild() {
    return false;
  }

  bool UVEditView::selectSiblingNext() {
    return false;
  }

  bool UVEditView::selectSiblingPrev() {
    return false;
  }

  static bool selectedObjectsCondition(const Aztec::MSceneObjectPtr &sceneObj, const Aztec::MMeshPtr &textureMesh) {
    return (sceneObj->isFlagged(OBJECTFLAG_SELECTED));
  }

  static bool selectNoneFunc(const Aztec::MSceneObjectPtr &sceneObj, const Aztec::MMeshPtr &textureMesh) {
    for (int i = 0; i < textureMesh->getComponentCount(Aztec::MUIManager::getComponentMode()); ++i) {
      textureMesh->selectComponent(Aztec::MUIManager::getComponentMode(),i, false);
    }
    return true;
  }

  class AnythingSelected {
  public:
    AnythingSelected() {
      anythingSelected = false;
    }
    bool operator()(const Aztec::MSceneObjectPtr &sceneObj, const Aztec::MMeshPtr &textureMesh) const {
      for (int i = 0; i < textureMesh->getComponentCount(Aztec::MUIManager::getComponentMode()); ++i) {
        if (textureMesh->isComponentFlagged(Aztec::MUIManager::getComponentMode(), i)) {
          anythingSelected = true;
          return false;
        }
      }
      return true;
    }

    mutable bool anythingSelected;
  };

  bool UVEditView::selectNone() {
    iterateOverTextureMeshes(Aztec::MScene::getGlobalScene(), &selectedObjectsCondition, &selectNoneFunc);
    
    return true;
  }

  bool UVEditView::selectAll() {
    return true;
  }

  bool UVEditView::selectInverse() {
    return true;
  }

  bool UVEditView::selectAllChildren() {
    return false;
  }

  bool UVEditView::anythingSelected() {
    AnythingSelected anything;

    iterateOverTextureMeshes(Aztec::MScene::getGlobalScene(), &selectedObjectsCondition, &anything);

    return anything.anythingSelected;
  }


  class GetCentre {
  public:
    GetCentre() {
      count = 0;
    }
    bool operator()(const Aztec::MSceneObjectPtr &sceneObj, const Aztec::MMeshPtr &textureMesh) const {
      ++count;
      centre += textureMesh->getFlaggedCentre(Aztec::MUIManager::getComponentMode());
            
      return true;
    }

    Aztec::MVector3 getCentre() {
      if (count == 0) {
        return Aztec::MVector3(0,0,0);
      } else {
        return centre / count;
      }

    }
  private:

    mutable Aztec::MVector3 centre;
    mutable int count;
  };


  Aztec::MVector3 UVEditView::getSelectionCentre() {
    GetCentre centre;

    iterateOverTextureMeshes(Aztec::MScene::getGlobalScene(), &selectedObjectsCondition, &centre);

    return centre.getCentre();
  }



}

