#include <Aztec3DPCH.h>

#include <functions/file/FileFunctions.h>

#include <views/ImageView.h>

#include <gui/MBorderLayout.h>
#include <gui/MScrolledContainer.h>
#include <gui/MOpenFileDialog.h>

#include <MSystemManager.h>
#include <MImages.h>



namespace AztecGUI {

  ImageView::ImageView() 
    : AztecView("Image View")
  {
  }

	ImageView::~ImageView() {
  }

  bool ImageView::openImage() {
    // try and load an image.
    
    Aztec::MOpenFileDialogPtr dlg = new Aztec::MOpenFileDialog;
    
    // add in all the filters from the scene translators
    Aztec::MPluginManagerPtr plugMan = Aztec::MSystemManager::getInstance()->getPluginManager();
    Aztec::MPluginManager::ImageTranslatorVector translators = plugMan->getImageTranslators(Aztec::MPluginManager::MUST);
    
    for (unsigned i = 0; i < translators.size(); ++i) {
      dlg->addFilter(translators[i]->getFilterDescription(), translators[i]->getFilter());
    }
    
    dlg->setTitle("Open an image...");
    
    // Show the dialog, and if OK is pressed, so something useful.
    if (dlg->doModal()) {
      
      // The current filter for the dialog is >= 0 for manually picked filters, otherwise < 0 for automatically generated ones.
      if (dlg->getFilter() >= 0) {
        // If the user has picked a certain translator, use that translator, otherwise just use a general one.
        Aztec::MImageTranslatorPtr trans = translators[dlg->getFilter()];
        // if we have a translator, try to import the file.
        if (trans != NULL) {
          
          Aztec::MImagePtr image = new Aztec::MImage();
          
          // now try to import it.
          bool result = trans->importFile(dlg->getFilename().c_str(), image);
          
          if (result) {
            setImage(image);
          } else {
            Aztec::MSystemManager::getInstance()->logOutput("Error: failed to load image '%s'", dlg->getFilename().c_str());
          }
          
          return result;
        } else {
          return false;
        }
      } else {
        Aztec::MImagePtr image = Aztec::MSystemManager::getInstance()->loadImage(dlg->getFilename());
        
        if (image == NULL) {
          Aztec::MSystemManager::getInstance()->logOutput("Error: failed to load image '%s'", dlg->getFilename().c_str());
          return false;
        } else {
          setImage(image);
          return true;
        }
      }
      
    } else {
      // if we have a null translator, we have failed.
      return false;
    }

  }

  bool ImageView::saveImageAs() {
    return imageSaveAs(imageComponent->getImage());
  }

  // AztecView Methods
  AztecViewPtr ImageView::createCopy() {
    ImageViewPtr result = new ImageView();

    if (imageComponent != NULL) {
      result->storedImage = imageComponent->getImage();
    }

    return result;
  }

  std::string ImageView::getViewGroup() const {
    return "ImageView";
  }

  void ImageView::drawView() {
  }


  // MComponent methods
  void ImageView::onCreate() {
    AztecView::onCreate();

    // add in a new menu
    Aztec::MMenuBarPtr menuBar = getMenuBar();
    Aztec::MMenuPtr fileMenu = new Aztec::MMenu();
    fileMenu->addItem(new Aztec::MMenuItem("Open Image...", "Scene.imageViewOpenImage()"));
    fileMenu->addItem(new Aztec::MMenuItem("Save Image...", "Scene.imageViewSaveImageAs()"));

    Aztec::MMenuItemPtr fileMenuItem = new Aztec::MMenuItem("File", fileMenu);

    viewMenuBar->addItem(fileMenuItem, 0);

    Aztec::MContainerPtr content = new Aztec::MContainer();
    content->setLayoutManager(new Aztec::MBorderLayout());

    addComponent(content, Aztec::MBorderLayout::CENTRE);

    Aztec::MScrolledContainerPtr scroller = new Aztec::MScrolledContainer();
    content->addComponent(scroller, Aztec::MBorderLayout::CENTRE);

    imageComponent = new Aztec::MImageComponent();

    imageComponent->setImage(storedImage);
    scroller->addComponent(imageComponent, Aztec::MBorderLayout::CENTRE);

  }


  void ImageView::setImage(const Aztec::MImagePtr &image) {
    if (imageComponent != NULL) {
      imageComponent->setImage(image);
    }
    doLayout();
  }


}

