#include <Aztec3DPCH.h>
#include <tools/MMovePivotTool.h>


// Aztec2 includes
#include <views/Aztec3DView.h>
#include <utils/AztecGLUtils.h>
#include <config/UIConfig.h>

// AztecLib includes
#include <MSceneObject.h>
#include <MEditableMesh.h>
#include <MUIManager.h>
#include <MScene.h>

namespace AztecGUI {

  MMovePivotTool::MMovePivotTool()
  {
    m_RequiresSel = true;
  }

  std::string MMovePivotTool::getName() {
    return "toolMovePivot";
  }

  int MMovePivotTool::drawTool(bool select, const Aztec::MComponentPtr &component)
  {
    // Get the current viewport and cast it to a gl wnd.
    Aztec::MVector3 PivotPoint;
    bool DrawManips;
 
    AztecGLCanvasPtr GLWnd = AztecGLView::getGLCanvasFor(component);

    if (GLWnd == NULL)
      return 0;
  
    PivotPoint = Aztec::MScene::getGlobalScene()->getSelectionCentre();
    // we should not update our axis if we are dragging, otherwise
    // the axis would change as we move things!
    if (!m_Dragging) {
      getAxisMatrix(GLWnd);
    }
  
    glPushAttrib(GL_ENABLE_BIT);
    glDisable(GL_DEPTH_TEST);
  
  
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glLoadIdentity();
  
    // Perform the viewport transformation
  
    GLWnd->doCameraTransform();
    glMatrixMode(GL_MODELVIEW);
  
    glPushMatrix();
    float ScaleFact = GLWnd->getScalingFactor(PivotPoint);
    glTranslatef(PivotPoint.x, PivotPoint.y, PivotPoint.z);
  
    glScalef(ScaleFact, ScaleFact, ScaleFact);
  
    if (RequiresSelection()) {
      DrawManips = Aztec::MScene::getGlobalScene()->anythingSelected();
    } else {
      DrawManips = true;
    }
  
    if (DrawManips)
    {
      glDrawAxisIcon(UIConfig::get3DWidgetSize(), 0.5f, 2.0f, select, DRAWAXIS_ALLAXES);
    
      if (m_Dragging)
      {
        glPopMatrix();
        glPushMatrix();
        glTranslatef(m_MoveStart.x, m_MoveStart.y, m_MoveStart.z);
        glScalef(ScaleFact, ScaleFact, ScaleFact);
        glDrawAxisIcon(UIConfig::get3DWidgetSize(), 0.2f, 2.0f, false, DRAWAXIS_ALLGRAY | DRAWAXIS_ALLAXES);
      
      }
    }
  
    glPopMatrix();
    glPopMatrix();
  
    glPopAttrib();
  
    return 1;
  }

  int MMovePivotTool::onMouseDown(const Aztec::MMouseEvent &event)
  {
    Aztec::MVector3 Orig, Dir, ViewNorm;
    Aztec::MMatrix4 XFormMat;
  
    getPlaneParams(AztecGLView::getGLCanvasFor(event.getComponent()),m_Constraint, m_AxisTransform);
  
    Dir.normalize();
  
    m_MoveStart = Aztec::MScene::getGlobalScene()->getSelectionCentre();
  
    MXYZToolType::onMouseDown(event);
  
    return TOOLRESULT_DRAWALL;
  }

  int MMovePivotTool::onMouseUp(const Aztec::MMouseEvent &event)
  {
    MXYZToolType::onMouseUp(event);
  
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSLATE);
  
    return TOOLRESULT_DRAWALL;
  }

  int MMovePivotTool::onMouseMove(const Aztec::MMouseEvent &event)
  {
    MXYZToolType::onMouseMove(event);
  
    if (!m_Dragging) {
      return TOOLRESULT_DRAWNONE;
    }
  
    Aztec::MVector3  OfsVec, MoveVec;
  
    OfsVec = m_CurVec;
    OfsVec -= m_DownVec;
  
    // Go through the currently selected objects, and move their components.
    Aztec::MBaseObjectPtr BaseObj;
    Aztec::MSceneObjectPtr Obj;
    Aztec::MScene::getGlobalScene()->getObjectList()->beginIteration();
    while (( BaseObj = Aztec::MScene::getGlobalScene()->getObjectList()->getNext() ) != NULL ) {
      Obj = AZTEC_CAST(Aztec::MSceneObject, BaseObj);
      if (Obj == NULL)
        continue;
    
      Aztec::MTreeObjectNodePtr ObjNode;
      Aztec::MComponentisedObjectPtr compObj = Obj->getComponentObject();
    
      ObjNode = Aztec::MScene::getGlobalScene()->getObjectList()->getCurrentNode();
    
      if (compObj == NULL || !compObj->isInComponentMode()) {
        {
          Aztec::MTreeObjectNodePtr ParentNode;
          ParentNode = ObjNode->getParent();
        
          MoveVec = Aztec::MScene::getGlobalScene()->worldToObjectSpace(ParentNode, m_CurVec);
          MoveVec -= Aztec::MScene::getGlobalScene()->worldToObjectSpace(ParentNode, m_DownVec);
        
          MoveVec = OfsVec;
        }
      
      
        Aztec::MTransformObjectPtr XForm;
        Aztec::MVector3          Vec;
      
        XForm = Aztec::MScene::getGlobalScene()->getTransform(Aztec::MScene::getGlobalScene()->getObjectList()->getCurrentNode());
      
        if (XForm != NULL) {
          Aztec::MVector3 Vec;
        
          Vec = XForm->getPivotPoint();
        
          Vec = m_MoveStart + MoveVec;
        
          Vec = Aztec::MScene::getGlobalScene()->worldToObjectSpace(ObjNode, Vec);
          XForm->setPivotPoint(Vec);
        }
      }
    }
    Aztec::MScene::getGlobalScene()->getObjectList()->endIteration();
  
    return TOOLRESULT_DRAWALL;
  }

  int MMovePivotTool::getDefaultManip() {
    return 4;
  }

}