#include <Aztec3DPCH.h>

#include <functions/edit/VisibilityFunctions.h>

// Aztec2 includes
#include <views/AztecViewManager.h>
#include <utils/SceneFunctions.h>

// AztecLib includes
#include <MScene.h>
#include <MSystemManager.h>
#include <MUIManager.h>


namespace AztecGUI {


  class FindMaterial {
  public:
    FindMaterial(Aztec::MMaterialPtr *mat) {
      material = mat;
    }

    void operator()(const Aztec::MScenePtr &scene, const Aztec::MTreeObjectNodePtr &node) {
      Aztec::MMaterialPtr mat = AZTEC_CAST(Aztec::MMaterial, node->getObject());

      if (mat != NULL) {
        *material = mat;
      }
    }

    Aztec::MMaterialPtr *material;
  };

  class AssignMaterial {
  public:
    AssignMaterial(Aztec::MMaterialPtr mat) {
      material = mat;
    }

    void operator()(const Aztec::MScenePtr &scene, const Aztec::MTreeObjectNodePtr &node) {
      Aztec::MSceneObjectPtr obj = AZTEC_CAST(Aztec::MSceneObject, node->getObject());

      if (obj != NULL) {
        obj->setTextureMaterial(material);
      }
    }

  private:
    Aztec::MMaterialPtr material;
  };


  static int assignSelectedMaterial(const StringVector &args, std::string &result) {
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();

    // first find any selected materials.
    Aztec::MMaterialPtr mat;
    FindMaterial materialFinder(&mat);
    applyToObjects(scene, scene->getObjectList(), ifSelectedCriteria, materialFinder);

    // now apply those materials to every object.
    applyToObjects(scene, scene->getObjectList(), ifSelectedCriteria, AssignMaterial(mat));


    AztecViewManager::redrawAllViews();

    return FunctionManager::SUCCEED;
  }

  void registerMaterialFunctions(FunctionManager &man) {

    man.registerFunction("assignSelectedMaterial", assignSelectedMaterial);

  }


}

