#include <Aztec3DPCH.h>
#include <controls/ToolButton.h>

// AztecLib includes
#include <MSystemManager.h>
#include <scripting/MScriptInterp.h>
#include <misc/ResourceManager.h>


namespace AztecGUI {

  static std::string makeCommand(const std::string &group, const std::string &toolname) {
    return std::string("Scene.toolSetCurrent('") + group + std::string("', '") + toolname + "');";
  }
  
  
  
  ToolButton::ToolButton(const std::string &caption, const std::string &group, const std::string &toolname)
    : CommandButton(caption, makeCommand(group, toolname)) ,
    name(toolname),
    group(group)
  {
    MToolManager::getInstance()->addListener(new ToolButtonListener(this), group);
    
    setImage(Aztec::MSystemManager::getInstance()->loadImage(
      Aztec::ResourceManager::locateResource("icons/tools/" + toolname + ".bmp")));
  }
  
  void ToolButton::setTool(const std::string &caption, const std::string &group, const std::string &toolname) {
    this->name = toolname;
    setCaption(caption);
    setCommand(makeCommand(group, toolname));

    setImage(Aztec::MSystemManager::getInstance()->loadImage(
      Aztec::ResourceManager::locateResource("icons/tools/" + toolname + ".bmp")));
  }
  
  
  ToolButtonListener::ToolButtonListener(ToolButton *but) 
    : b(but)
  {
  }
  
  void ToolButtonListener::onToolChange(const std::string &group, MToolTypePtr oldTool) {
    if (b->group == group) {
      b->setButtonDown(MToolManager::getInstance()->GetTool(group)->getName() == b->name);
    }
  }




}

