#include <Aztec3DPCH.h>

#include <gui/MFlowLayout.h>
#include <gui/MBorderLayout.h>
#include <gui/MGridLayout.h>
#include <gui/MTextField.h>

// Aztec2 includes
#include <controls/CommandButton.h>

#include <controls/TimeControlPanel.h>

namespace AztecGUI {
  TimeControlPanel::TimeControlPanel() {
  }

  void TimeControlPanel::onCreate() {
    setLayoutManager(new Aztec::MBorderLayout(0,0));

    // make some edit controls.
    Aztec::MContainerPtr top, bottom;

    top = new Aztec::MContainer();
    top->setLayoutManager(new Aztec::MFlowLayout(2,0,1));
    addComponent(top, Aztec::MBorderLayout::NORTH);


    bottom = new Aztec::MContainer();
    bottom->setLayoutManager(new Aztec::MFlowLayout(2,0));
    addComponent(bottom, Aztec::MBorderLayout::SOUTH);

    Aztec::MContainerPtr controlButtons = new Aztec::MContainer();
    top->addComponent(controlButtons);
    controlButtons->setLayoutManager(new Aztec::MGridLayout(5, 1));
    controlButtons->addComponent(new CommandButton("<|", "Scene.timeFramePrevKey()"));
    controlButtons->addComponent(new CommandButton("<", "Scene.timeFramePrev()"));
    controlButtons->addComponent(new CommandButton("P", "Scene.timePlay()"));
    controlButtons->addComponent(new CommandButton(">", "Scene.timeFrameNext()"));
    controlButtons->addComponent(new CommandButton("|>", "Scene.timeFrameNextKey()"));

    bottom->addComponent(new CommandButton("Animate", "a"));
    bottom->addComponent(new Aztec::MTextField());

  }

}

