
#include <Aztec3DPCH.h>
#include <iostream>

// Aztec2 includes
#include <tools/MToolManager.h>
#include <tools/MGLMoveTool.h>
#include <views/Aztec3DView.h>
#include <views/AztecViewManager.h>
#include <tools/RegisterDefaultTools.h>
#include <functions/FunctionManager.h>
#include <functions/AllFunctions.h>
#include <views/AztecViewManager.h>
#include <controls/MainWindow.h>

// AztecGUI includes
#include <gui/MApplication.h>
#include <config/UIConfig.h>
#include <gui//MTextField.h>

// AztecLib includes
#include <MSystemManager.h>
#include <scripting/MScriptInterp.h>
#include <misc/ResourceManager.h>

AztecGUI::FunctionManager funcMan;


class MyApp : public Aztec::MApp {
public:

  class AztecScriptCallbacks : public CScriptCallbacks { 
  public:
    int puts(const char *str) {
      Aztec::MSystemManager::getInstance()->logOutput("JS: %s", str);
      return 1;
    }

    void updateDisplay() {
      AztecGUI::AztecViewManager::redrawAllViews();
    }

    actionFunc* getActionFunction(const char *actionName) {
      return NULL;
    }

    actionFuncWithArgs* getActionFunctionWithArgs(const char *actionName) {
      return funcMan.getFunction(actionName);
    }

  };

  AztecScriptCallbacks callbacks;

  // MApp methods
  bool initApp() {
    AztecGUI::registerAllFunctions(funcMan);

    // set up our resource locations
    Aztec::ResourceManager::addResourcePath("");
    Aztec::ResourceManager::addResourcePath(".");
    Aztec::ResourceManager::addResourcePath(getApplicationPath());
    Aztec::ResourceManager::addResourcePath(getApplicationPath() + "/../../common2");
    Aztec::ResourceManager::addResourcePath("$(AZTEC_SCRIPT_PATH)");

    // TODO: Remove this additional resource path when the Linux makefiles are redone
  #ifndef _WIN32
    Aztec::ResourceManager::addResourcePath(getApplicationPath() + "/../src/resource");
  #endif

    // now try and load our plugins
  #ifdef _WIN32
    Aztec::MSystemManager::getInstance()->findAndLoadDLLs(getApplicationPath().c_str(), "*.dll");
  #else
    Aztec::MSystemManager::getInstance()->findAndLoadDLLs(getApplicationPath().c_str(), "*.so");
  #endif

    // Set up the script interpreter so it can output text and update the gui.
    Aztec::MScriptInterpreter::getInstance()->putCallbacks(&callbacks);

    // Initialise our UI Config class.
    AztecGUI::UIConfig::initialise();

    // set up our default tools.
    AztecGUI::registerDefaultTools();

    // set up our global scene.
    Aztec::MScene::setGlobalScene(new Aztec::MScene);

    // Load our inital configuration
    AztecGUI::UIConfig::loadConfig();

    // Create our main window.
    Aztec::MWindowPtr window = new AztecGUI::MainWindow();
    window->create();

    // run our initialisation script
    Aztec::MScriptInterpreter::getInstance()->ExecuteScript((std::string("cd('") + getApplicationPath() + "/../../common2/scripts');").c_str());

    std::string result;
    Aztec::MScriptInterpreter::getInstance()->ExecuteScript("load('init.js');", result);

    // Show the main window.
    window->setVisible(true);

    return true;
  }

  void MyApp::cleanup() {
    // save our config
    AztecGUI::UIConfig::saveConfig();

    Aztec::MSystemManagerPtr sysMan = Aztec::MSystemManager::getInstance();

    sysMan->logOutput("Closing down application...");

    sysMan->getUndoManager()->clearUndoInfo();

    AztecGUI::MToolManager::cleanup();

    // clean up the view manager.
    AztecGUI::AztecViewManager::cleanup();

    // clean up any logging we added in
    sysMan->getLogger()->removeAllListeners();

    sysMan->logOutput("Cleaning the JavaScript Interpreter...");
    Aztec::MScriptInterpreter::cleanInstance();

    sysMan->logOutput("cleaning Application...");
    MApp::cleanup();

    sysMan->logOutput("Removing the global scene...");
    Aztec::MScene::setGlobalScene(NULL);

    sysMan->logOutput("Cleaning up the system manager...");

    // We have to set this to null, because we have a ref counted pointer to the system manager
    sysMan = NULL;
    Aztec::MSystemManager::cleanInstance();
  }

  bool onCommand(const std::string &command, const Aztec::MComponentPtr &component) {
    // First change the current view to match the source of the event.
    AztecGUI::AztecViewPtr newView = AztecGUI::AztecView::getViewForComponent(component);
    if (newView != NULL) {
      AztecGUI::AztecViewManager::setCurrentView(newView);
    }

    // Check to see if we have a command, if we do, try and execute it via the script interpreter.
    if (command.length() > 0) {
      Aztec::MSystemManager::getInstance()->logOutput(command.c_str());
      
      std::string result;
      Aztec::MScriptInterpreter::getInstance()->ExecuteScript(command.c_str(), result);

      return true;
    } else {
      return false;
    }
  }

  bool onMouseMove(const Aztec::MMouseEvent &event) {
    // Make the view that the component was in the current view
    AztecGUI::AztecViewPtr newView = AztecGUI::AztecView::getViewForComponent(event.getComponent());
    if (newView != NULL) {
      AztecGUI::AztecViewManager::setLastMouseOverView(newView);
    }

    return false;
  }

  bool onMousePressed(const Aztec::MMouseEvent &event) {
    // Make the view that the component was in the current view
    AztecGUI::AztecViewPtr newView = AztecGUI::AztecView::getViewForComponent(event.getComponent());
    if (newView != NULL) {
      AztecGUI::AztecViewManager::setCurrentView(newView);
    }

    // we return false because we do not want to stop other controls from processing this message.
    return false;
  }

  bool onMouseReleased(const Aztec::MMouseEvent &event) {
    // Make the view that the component was in the current view
    AztecGUI::AztecViewPtr newView = AztecGUI::AztecView::getViewForComponent(event.getComponent());
    if (newView != NULL) {
      AztecGUI::AztecViewManager::setCurrentView(newView);
    }

    // we return false because we do not want to stop other controls from processing this message.
    return false;
  }

  bool onKeyPressed(const Aztec::MKeyEvent &event) {
    std::string str = AztecGUI::UIConfig::getShortcut(event.getCode(), event.getShiftState(), 
                                                             event.getType() == Aztec::MKeyEvent::KEY_DOWN);

    // we only want to react to key presses if we are not in some sort of editable field
    if (AZTEC_CAST(Aztec::MTextField, event.getComponent()) == NULL) {
      if (str != "") {
        return Aztec::MScriptInterpreter::getInstance()->ExecuteScript(str.c_str());
      }
    }

    // if nothing happened, then indicate we havne't handled the key event.
    return false;
  }
};


AZTEC_USE_APP(MyApp);

