#ifndef AztecViewManager_Header
#define AztecViewManager_Header

#include <views/AztecView.h>

namespace AztecGUI {

  class AztecViewManager {
  public:
    /**
     * Cleans up any information used in the view manager.
     */
    static void cleanup();

    static AztecViewPtr getCurrentView();
    static void setCurrentView(const AztecViewPtr &view);

    /**
     * This is used to keep track of what view the mouse was last moved over, 
     * and is not necessarily the current view. This is used for things like 
     * toggling full screen, and thigns like that.
     */
    static void setLastMouseOverView(AztecViewPtr &view);

    /**
     * This is used to keep track of what view the mouse was last moved over, 
     * and is not necessarily the current view. This is used for things like 
     * toggling full screen, and thigns like that.
     */
    static AztecViewPtr getLastMouseOverView();

    static void redrawAllViews();
    static void redrawCurrentView();

    static void registerView(AztecView *view);
    static void unregisterView(AztecView *view);

    /**
     * This stores the given view so that views can be created on demand just 
     * from a name. This allows run time creation of views without knowing the
     * type ahead of time.
     */
    static void registerViewType(const std::string &viewType, const AztecViewPtr &view);

    /**
     * This finds the stored view of the given type, and then returns 
     * view->createCopy(). If the view type has not been registered via 
     * registerViewType(), this method will return null.
     */
    static AztecViewPtr createView(const std::string &viewType);

    /**
     * This reenables viewport updating after a call to disable viewport 
     * updating. Any viewports that were attempted to be updated will 
     * now be redrawn.
     *
     * Calls to disable/enable viewport updating can be nested.
     */
    static void enableViewUpdating();

    /**
     * Disablings all viewport updating via the view manager until a matching 
     * call to enableViewUpdating() is made. This does not stop views from 
     * drawing in general, just from calls to 
     * AztecViewManager::redrawAllViews() and AztecViewManager::redrawCurrentView().
     *
     * Calls to disable/enable viewport updating can be nested.
     */
    static void disableViewUpdating();
  };


}



#endif

