#ifndef AztecKeyUtils_Header
#define AztecKeyUtils_Header

namespace AztecGUI {

  class Keyboard {
  public:
    /**
     * This checks to see if the given event has the combination of keys used 
     * to indicate we are toggling a selection.
     */
    template <class EventType>
    static bool isToggleSelectionKey(const EventType &event) {
      return event.isControlDown() && !event.isShiftDown() && !event.isAltDown();
    }

    /**
     * This checks to see if the given event has the combination of keys used 
     * to indicate we are adding to a selection
     */
    template <class EventType>
    static bool isAddSelectionKey(const EventType &event) {
      return event.isControlDown() && event.isShiftDown() && !event.isAltDown();
    }

    /**
     * This checks to see if the given event has the combination of keys used 
     * to indicate we are subtracting from a selection
     */
    template <class EventType>
    static bool isSubtractSelectionKey(const EventType &event) {
      return event.isControlDown() && !event.isShiftDown() && event.isAltDown();
    }

  };

}


#endif

