#ifndef MSelectTool_Header
#define MSelectTool_Header

#include <tools/MToolType.h>

#include <gui/MComponent.h>

namespace AztecGUI {

  class MSelectToolType : public MToolType
  {
  protected:
     bool     m_Selecting, m_Deselecting, m_BoxSelect;

  public:
     MSelectToolType();

     // MToolType methods
     std::string getName();
     void initialise();

     /**
      * Cancelling this tool does several things:
      * <ul>
      * <li>If we are in object mode, then cancelling clears the current 
      *     selection.</li>
      * <li>If we are in component mode, cancelling clears the current 
      *     selection. If there are no components selected, we go to object 
      *     mode.</li>
      * </ul>
      */
     bool cancel();

     /**
      * In progress only returns true if we are drawing a selection box.
      */
     bool inProgress();

     int drawTool(bool Select, const Aztec::MComponentPtr &view);
     int onMouseDown(const Aztec::MMouseEvent &event);
     int onMouseUp(const Aztec::MMouseEvent &event);
     int onMouseMove(const Aztec::MMouseEvent &event);

  private:
    /**
     * This is used to keep track if the user has just cancelled. If they have, 
     * then the current selection has been cleared. If we cancel twice in a row
     * then we have to go back to object mode.
     */
    bool justCancelled;

    /**
     * Used to indicate if we are drawing a box selection or not.
     */
    bool drawingBox;
  
    int processSelectionItem(const Aztec::MSelectionItem& item, bool targetSelection, bool toggleSelection, const Aztec::MRay &viewer, const Aztec::MMouseEvent &event);
    int processComponentSelectionItem(const Aztec::MSelectionItem& item, bool targetSelection, bool toggleSelection, const Aztec::MRay &viewer, const Aztec::MMouseEvent &event);
  };

}

#endif

