#ifndef Aztec2_Inset_Tool_Header
#define Aztec2_Inset_Tool_Header


#include <tools/MXYZToolType.h>
#include <MEditableMesh.h>
#include <functions/mesh/MeshFunctions.h>


namespace AztecGUI {

  /**
   * This toll is an interactive extrusion tool allowing
   * faces on a polygonal mesh to be selected and extruded.
   * When a set of faces are selected, an handle appears allowing
   * the user to grabe it and extrude fces apropriately.
   */
  class InsetTool : public MXYZToolType
  {
  public:
    InsetTool();
    
    // MToolType methods
    std::string getName();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    
    int WrapMouse() {return 1;};
    int getDefaultManip() {return 3;};

  protected:
     /**
      * This gets the selection normal, and returns true if some
      * face were selected, false if nothing was selected.
      */
     bool updateExtrudeNormal();

     /**
      * This is directio that we are extruding in
      */
     Aztec::MVector3 m_ExtrudeVec;
     /**
      * This is the transformation matrix to use when
      * drawing the widgets
      */
     Aztec::MMatrix4 m_GLTransform;
     /**
      * This indicates if we are acutally extrusing yet, or
      * just looking at stuff.
      */
     bool dragging;
     /**
      * This is the Distance that we have extruded along
      * the extrude vector so far.
      */
     double distance;

     /**
      * This is the starting point for extrusion.
      */
     Aztec::MVector3 m_StartPos;
     /**
      * This is the current centre of the centre of the
      * faces during extrusion.
      */
     Aztec::MVector3 m_CurrentPos;

     Aztec::MVector3 mouseStartedPos;

  };


}

#endif

